<?php
/* @package ThemeNio
 * @name: ThemeNio FrameWork
 * @copyright ThemeNio
 * @version - 1.6.0
 */
// ThemeNio Option Class
class Nio_Theme_Options {
	private $sections;
	private $checkboxes;
	private $settings;
	
	// Construct 
	public function __construct() {
		
		// This will keep track of the checkbox options for the validate_settings function.
		$this->checkboxes = array();
		$this->settings = array();
		$this->get_settings();
		
		$this->sections['general']      = __( 'General' );
		$this->sections['social']      = __( 'Social Media' );
		$this->sections['headers']      = __( 'Header Style' );
		$this->sections['appearance']   = __( 'Appearance' );
		$this->sections['others']      = __( 'Others' );
		$this->sections['reset']        = __( 'Reset' );
		
		add_action( 'admin_menu', array( &$this, 'add_pages' ) );
		add_action( 'admin_init', array( &$this, 'register_settings' ) );
		
		if ( ! get_option( 'theme_settings' ) )
			$this->initialize_settings();
	}
	
	// Add options page
	public function add_pages() {
		$admin_page = add_theme_page( __('Theme Options'), __('Theme Options'), 'manage_options', 'theme-settings', array( &$this, 'display_option'));
		// Load Script and Stylesheet
		add_action( 'admin_print_scripts-' . $admin_page, array( &$this, 'scripts' ) );
		add_action( 'admin_print_styles-' . $admin_page, array( &$this, 'styles' ) );
	}
	
	// Create settings field
	public function create_setting( $args = array() ) {
		
		$defaults = array(
			'id'      => 'default_field',
			'title'   => __( 'Default Field' ),
			'desc'    => __( 'This is a default description.' ),
			'std'     => '',
			'type'    => 'text',
			'section' => 'general',
			'choices' => array(),
			'class'   => ''
		);
			
		extract( wp_parse_args( $args, $defaults ) );
		
		$field_args = array(
			'type'      => $type,
			'id'        => $id,
			'desc'      => $desc,
			'std'       => $std,
			'choices'   => $choices,
			'label_for' => $id,
			'class'     => $class
		);
		
		if ( $type == 'checkbox' )
			$this->checkboxes[] = $id;
	
		add_settings_field( $id, $title, array( $this, 'display_setting' ), 'theme-settings', $section, $field_args );
	}
	
	// Display options page
	public function display_option() {
		
		echo '<div class="theme-nio wrap">
		<div class="icon32" id="icon-options-general"></div>
		<h1>' . __( 'Theme Options' ) . '</h1>';
	
		if ( isset( $_GET['settings-updated'] ) && $_GET['settings-updated'] == true )
			echo '<div class="updated fade"><p>' . __( 'Theme Options updated.' ) . '</p></div>';
		
		echo '<form action="options.php" method="post">';
	
		settings_fields( 'theme_settings' );
		echo '<div class="ui-tabs">
			<ul class="ui-tabs-nav">';
		
		foreach ( $this->sections as $section_slug => $section )
			echo '<li><a href="#' . $section_slug . '">' . $section . '</a></li>';
		
		echo '</ul>';
		do_settings_sections( $_GET['page'] );
		
		echo '</div>
		<p class="submit"><input name="Submit" type="submit" class="button-primary" value="' . __( 'Save Changes' ) . '" /></p></form>';
	
		echo '<script type="text/javascript">
		jQuery(document).ready(function($) {
			var sections = [];';
	
			foreach ( $this->sections as $section_slug => $section )
				echo "sections['$section'] = '$section_slug';";
			
			echo 'var wrapped = $(".wrap h2").wrap("<div class=\"ui-tabs-panel\"></div>");
			wrapped.each(function() {
				$(this).parent().append($(this).parent().nextUntil("div.ui-tabs-panel"));
			});
			$(".ui-tabs-panel").each(function(index) {
				$(this).attr("id", sections[$(this).children("h2").text()]);
				if (index > 0)
					$(this).addClass("ui-tabs-hide");
			});
			$(".ui-tabs").tabs({
				fx: { opacity: "toggle", duration: "fast" }
			});
		
			$("input[type=text], textarea").each(function() {
				if ($(this).val() == $(this).attr("placeholder") || $(this).val() == "")
					$(this).css("color", "#666");
			});
			
			$("input[type=text], textarea").focus(function() {
				if ($(this).val() == $(this).attr("placeholder") || $(this).val() == "") {
					$(this).val("");
					$(this).css("color", "#000");
				}
			}).blur(function() {
				if ($(this).val() == "" || $(this).val() == $(this).attr("placeholder")) {
					$(this).val($(this).attr("placeholder"));
					$(this).css("color", "#666");
				}
			});
			
			$(".wrap h3, .wrap table").show();
			
			// This will make the "warning" checkbox class really stand out when checked.
			// I use it here for the Reset checkbox.
			$(".warning").change(function() {
				if ($(this).is(":checked"))
					$(this).parent().css("background", "#c00").css("color", "#fff").css("fontWeight", "bold");
				else
					$(this).parent().css("background", "none").css("color", "inherit").css("fontWeight", "normal");
			});
				});
				</script>
			</div>';
				
	}
	
	// Description for section
	public function display_section() {
		// code
	}
		
	// HTML output for text field
	public function display_setting( $args = array() ) {
		
		extract( $args );
		
		$options = get_option( 'theme_settings' );
		
		if ( ! isset( $options[$id] ) && $type != 'checkbox' )
			$options[$id] = $std;
		elseif ( ! isset( $options[$id] ) )
			$options[$id] = 0;
		
		$field_class = '';
		if ( $class != '' )
			$field_class = ' ' . $class;
		
		switch ( $type ) {
			
			case 'heading':
				echo '</td></tr><tr valign="top"><td colspan="2"><h4>' . $desc . '</h4>';
				break;
			
			case 'checkbox':
				
				echo '<input class="checkbox' . $field_class . '" type="checkbox" id="' . $id . '" name="theme_settings[' . $id . ']" value="1" ' . checked( $options[$id], 1, false ) . ' /> <label for="' . $id . '">' . $desc . '</label>';
				
				break;
			
			case 'select':
				echo '<select class="select' . $field_class . '" name="theme_settings[' . $id . ']">';
				
				foreach ( $choices as $value => $label )
					echo '<option value="' . esc_attr( $value ) . '"' . selected( $options[$id], $value, false ) . '>' . $label . '</option>';
				
				echo '</select>';
			
				if ( $desc != '' )
					echo '<br /><span class="description">' . $desc . '</span>';
				
				break;
			
			case 'radio':
				$i = 0;
				foreach ( $choices as $value => $label ) {
					echo '<input class="radio' . $field_class . '" type="radio" name="theme_settings[' . $id . ']" id="' . $id . $i . '" value="' . esc_attr( $value ) . '" ' . checked( $options[$id], $value, false ) . '> <label for="' . $id . $i . '">' . $label . '</label>';
					if ( $i < count( $options ) - 1 )
						echo '<br />';
					$i++;
				}		
				if ( $desc != '' )
					echo '<br /><span class="description">' . $desc . '</span>';
				
				break;
			
			case 'textarea':
				echo '<textarea class="regular-text' . $field_class . '" id="' . $id . '" name="theme_settings[' . $id . ']"  rows="3" cols="39">' . format_for_editor( $options[$id] ) . '</textarea>';
				
				if ( $desc != '' )
					echo '<br /><span class="description">' . $desc . '</span>';
				
				break;
			
			case 'password':
				echo '<input class="regular-text' . $field_class . '" type="password" id="' . $id . '" name="theme_settings[' . $id . ']" value="' . esc_attr( $options[$id] ) . '" />';
				
				if ( $desc != '' )
					echo '<br /><span class="description">' . $desc . '</span>';
				
				break;
			
			case 'text':
			default:
		 		echo '<input class="regular-text' . $field_class . '" type="text" id="' . $id . '" name="theme_settings[' . $id . ']" value="' . esc_attr( $options[$id] ) . '" />';
		 		
		 		if ( $desc != '' )
		 			echo '<br /><span class="description">' . $desc . '</span>';
		 		
		 		break;
		 	
		}
		
	}
	
	// Settings and defaults
	public function get_settings() {
		// variable get from function.php
		global $headerOption;
		// User theme option
		require_once (dirname(__FILE__).'/../'.'theme-options.php');
		
		/* Global Settings
		===========================================*/
		
		// Basic
		if ($headerOption == 'basic') {
			$this->settings['header-style'] = array(
				'section' => 'headers',
				'title'   => __( 'Header Style' ),
				'desc'    => __( '' ),
				'type'    => 'select',
				'choices' => array('style1' => 'Regular', 'style2' => 'Transparent', 'style3' => 'Hide Header')
			);
		}
		
		// Advance
		if ($headerOption == 'advanced') {
			$this->settings['header-style'] = array(
				'section' => 'headers',
				'title'   => __( 'Header Style' ),
				'desc'    => __( '' ),
				'type'    => 'select',
				'choices' => array('style1' => 'Regular', 'style2' => 'Transparent', 'style3' => 'Hide Header')
			);
			
			$this->settings['header-skin'] = array(
				'section' => 'headers',
				'title'   => __( 'Transparent Skin' ),
				'desc'    => __( '' ),
				'type'    => 'select',
				'choices' => array('dark' => 'Dark', 'light' => 'Light')
			);
			
			$this->settings['header-trans'] = array(
				'section' => 'headers',
				'title'   => __( 'Transparent Level' ),
				'desc'    => __( '' ),
				'type'    => 'select',
				'choices' => array('100' => '100%', '90' => '90%', '80' => '80%', '70' => '70%', '60' => '60%', '50' => '50%', 
								   '40' => '40%', '30' => '30%', '20' => '20%', '10' => '10%', '0' => '0%')
			);
			$this->settings['header-tophide'] = array(
				'section' => 'headers',
				'title'   => __( 'Topbar in Sticky' ),
				'desc'    => __( 'If available into site' ),
				'type'    => 'select',
				'choices' => array('hide' => 'Hide', 'show' => 'Show')
			);
		}
		
		$this->settings['header-sticky'] = array(
			'section' => 'headers',
			'title'   => __( 'Sticky Header' ),
			'desc'    => __( '' ),
			'type'    => 'select',
			'choices' => array('no' => 'No', 'yes' => 'Yes')
		);
		
		$this->settings['header-opt'] = array(
			'section' => 'headers',
			'title'   => __( 'Banner/Title Option' ),
			'desc'    => __( 'Banner image/title show as default into page (option may overide)' ),
			'type'    => 'select',
			'choices' => array('no' => 'No', 'yes' => 'Yes')
		);
		
		$this->settings['headerbg'] = array(
			'section' => 'headers',
			'title'   => __( 'Header/Banner Image' ),
			'desc'    => __( 'Enter the image url for default header/banner image.' ),
			'std'     => '',
			'type'    => 'text'
		);
		
		$this->settings['headerbg-color'] = array(
			'section' => 'headers',
			'title'   => __( 'Header Background Color' ),
			'desc'    => __( 'Enter the background color, ex. #ff00ff' ),
			'std'     => '',
			'type'    => 'text'
		);
		
		$this->settings['footer_text'] = array(
			'section' => 'general',
			'title'   => __( 'Footer Copyright' ),
			'desc'    => __( 'Enter footer copyright text.' ),
			'std'     => '',
			'type'    => 'textarea'
		);
		
		$this->settings['fb_share_image'] = array(
			'title'   => __( 'Social Share Thumbnail' ),
			'desc'    => __( 'Enter the image url of social sharing.' ),
			'std'     => '',
			'type'    => 'text',
			'section' => 'social'
		);
		$this->settings['favicon'] = array(
			'section' => 'appearance',
			'title'   => __( 'Favicon' ),
			'desc'    => __( 'Enter the URL (with http://) to your custom favicon. It should be 16x16 pixels in size.' ),
			'type'    => 'text',
			'std'     => ''
		);
		
		$this->settings['grid-ex'] = array(
			'section' => 'appearance',
			'title'   => __( 'Extended Layout' ),
			'desc'    => __( 'Extend Grid layout 1200px to 1440px. Layout 1 / 30px Gap & Layout 2 / 20px Gap' ),
			'type'    => 'select',
			'choices' => array('no' => 'No', 'lgx3' => 'Layout 1', 'lgx2' => 'Layout 2')
		);
		
		$this->settings['google_code'] = array(
			'section' => 'appearance',
			'title'   => __( 'Google Analytics' ),
			'desc'    => __( 'Enter your analytics code. Note: Add code include "script"' ),
			'std'     => '',
			'type'    => 'textarea',
			'class'   => 'codes'
		);
		
		$this->settings['custom_css'] = array(
			'section' => 'appearance',
			'title'   => __( 'Custom Styles' ),
			'desc'    => __( 'Enter any custom CSS here to apply it to your theme.' ),
			'std'     => '',
			'type'    => 'textarea',
			'class'   => 'codes'
		);
		
		$this->settings['reset_theme'] = array(
			'section' => 'reset',
			'title'   => __( 'Reset theme' ),
			'type'    => 'checkbox',
			'std'     => 0,
			'class'   => 'warning', // Custom class for CSS
			'desc'    => __( 'Check this box and click "Save Changes" below to reset theme options to their defaults.' )
		);
	}
	
	// Initialize Settings 
	public function initialize_settings() {
		$default_settings = array();
		foreach ( $this->settings as $id => $setting ) {
			if ( $setting['type'] != 'heading' )
				$default_settings[$id] = $setting['std'];
		}
		update_option( 'theme_settings', $default_settings );
	}
	
	// Register Settings
	public function register_settings() {		
		register_setting( 'theme_settings', 'theme_settings', array ( &$this, 'validate_settings' ) );
		foreach ( $this->sections as $slug => $title ) {
			add_settings_section( $slug, $title, array( &$this, 'display_section' ), 'theme-settings' );
		}
		
		$this->get_settings();
		foreach ( $this->settings as $id => $setting ) {
			$setting['id'] = $id;
			$this->create_setting( $setting );
		}
	}
	
	// jQuery Tabs
	public function scripts() {
		wp_print_scripts( 'jquery-ui-tabs' );
	}
	// Styling for the theme options page
	public function styles() {
		wp_enqueue_style( 'admin', get_stylesheet_directory_uri() . '/inc/admin/css/admin.css' );
	}
	// Validate settings
	public function validate_settings( $input ) {
		if ( ! isset( $input['reset_theme'] ) ) {
			$options = get_option( 'theme_settings' );
						
			foreach ( $this->checkboxes as $id ) {
				if ( isset( $options[$id] ) && ! isset( $input[$id] ) )
					unset( $options[$id] );
			}	
			return $input;
		}
		return false;
	}
}
$theme_options = new Nio_Theme_Options();