<?php
/* @package ThemeNio
 * @copyright ThemeNio
 * @version 1.6.2.1
 * @updated 150830#iO
 * @tags meta-boxes for wordpress
 *
 * !Important Note: All the meta-box function initialize into theme-metabox.php (which is found in inc folder)
 *
**/
## Hide Title @since 1.2 @version 1.0
function titlemeta_func( $post ) {
	$values = get_post_custom( $post->ID );
	$show = isset( $values['title-show'] ) ? esc_attr( $values['title-show'][0] ) : '';
	$alter = isset( $values['title-alter'] ) ? esc_attr( $values['title-alter'][0] ) : '';
	wp_nonce_field( 'title_meta_box_nonce', 'title_box_nonce' );
	?>
	<p><input type="checkbox" name="title-show" id="title-show" <?php checked( $show, 'on' ); ?> />
	<label for="title-show">Check to hide title from page</label></p>
	<p><input type="checkbox" name="title-alter" id="title-alter" <?php checked( $alter, 'on' ); ?> />
	<label for="title-alter">Check to show as page header</label><br /><small><em>Overide hide option</em></small></p>
	<?php
}
add_action( 'save_post', 'titlemeta_save' );
function titlemeta_save( $post_id ) {
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
	if( !isset( $_POST['title_box_nonce'] ) || !wp_verify_nonce( $_POST['title_box_nonce'], 'title_meta_box_nonce' ) ) return;
	if( !current_user_can( 'edit_post', $post_id  ) ) return;
	$allowed = array( 'a' => array( 'href' => array()) );
	// UPDATE
	$show = ( isset( $_POST['title-show'] ) && $_POST['title-show'] ) ? 'on' : 'off';
	$alter = ( isset( $_POST['title-alter'] ) && $_POST['title-alter'] ) ? 'on' : 'off';
	update_post_meta( $post_id, 'title-show', $show );
	update_post_meta( $post_id, 'title-alter', $alter );
}
## Blog Category @since 1.2 @version 1.0
function iblogmeta_func( $post ) {
	$values = get_post_custom( $post->ID );
    $blog_cat =  isset($values['blog_cat']) ? $values['blog_cat'][0] : '';
    $blog_post_count =  isset($values['blog_post_count']) ? $values['blog_post_count'][0] : '';
	wp_nonce_field( 'iblog_cat_meta_box_nonce', 'iblog_cat_box_nonce' );
	?>
    <div style="overflow:hidden;">
        <div style="width:48%; margin-right:2%; float:left;">
            <p class="fld">Category Name (Slug):<br />
            	<input class="widefat" type="text" id="blog_cat" name="blog_cat" value="<?php echo $blog_cat; ?>">
                <br /><small>(Note: use comma for mulitiple category</small></p>
        </div>
        <div style="width:48%; margin-right:2%; float:left;">
            <p class="fld">Post Per Page:<br />
            	<input class="widefat" type="text" id="blog_post_count" name="blog_post_count" value="<?php echo $blog_post_count; ?>">
                <br /><small>(Display how many post in blog page</small></p>
        </div>
		<br style="clear:both" />
    </div>
	<?php	
}
add_action( 'save_post', 'iblogmeta_save' );
function iblogmeta_save( $post_id ) {
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
	if( !isset( $_POST['iblog_cat_box_nonce'] ) || !wp_verify_nonce( $_POST['iblog_cat_box_nonce'], 'iblog_cat_meta_box_nonce' ) ) return;
	if( !current_user_can( 'edit_post', $post_id ) ) return;
	$allowed = array( 'a' => array( 'href' => array()) );
	// UPDATE
	update_post_meta( $post_id, 'blog_cat', $_POST['blog_cat']); 
	update_post_meta( $post_id, 'blog_post_count', $_POST['blog_post_count']); 
}
## Header Option  @since 1.6 @version 1.0
function headermeta_func( $post ) {
	global $headerOption;
    $values = get_post_custom( $post->ID );
    $headerbg =  isset($values['headerbg']) ? $values['headerbg'][0] : '';
    $main_title =  isset($values['main-title']) ? $values['main-title'][0] : '';
    $sub_title =  isset($values['sub-title']) ?  $values['sub-title'][0] : '';
    $headerbg_color =  isset($values['headerbg-color']) ? $values['headerbg-color'][0] : '';
    $headerbg_height =  isset($values['headerbg-height']) ? $values['headerbg-height'][0] : '';
    $title_position =  isset($values['title-position']) ? $values['title-position'][0] : '';
    // For Advanced
    if ($headerOption == 'advanced') {
        $header_style =  isset($values['header-style']) ? $values['header-style'][0] : '';
        $header_sticky =  isset($values['header-sticky']) ? $values['header-sticky'][0] : '';
        $header_skin =  isset($values['header-skin']) ? $values['header-skin'][0] : '';
        $header_trans =  isset($values['header-trans']) ? $values['header-trans'][0] : '';
        $header_tophide =  isset($values['header-tophide']) ? $values['header-tophide'][0] : '';
        $header_btntxt =  isset($values['header-btntxt']) ? $values['header-btntxt'][0] : '';
        $header_btnurl =  isset($values['header-btnurl']) ? $values['header-btnurl'][0] : '';
        $header_btntab = isset( $values['header-btntab'] ) ? esc_attr( $values['header-btntab'][0] ) : '';
    }
	wp_nonce_field( 'headermeta_meta_box_nonce', 'headermeta_box_nonce' );
	?>
    <div class="inside-x" style="overflow:hidden;">
        <div class="field-row" style="width:49%; margin-right:2%; float:left;">
            <p class="fld"><strong>Banner/Page Title</strong></p>
            <p><input class="widefat" type="text" id="main-title" name="main-title" value="<?php echo $main_title; ?>"></p>
        </div>
        <div class="field-row" style="width:49%; float:left;">
            <p class="fld"><strong>Banner/Page Subtitle</strong></p>
            <p><input class="widefat" type="text" id="sub-title" name="sub-title" value="<?php echo $sub_title; ?>"></p>
        </div>
        <div class="field-row" style="width:49%; margin-right:2%; float:left;">
            <p class="fld"><strong>Header/Banner Image</strong></p>
            <p><input id="headerbg" name="headerbg" type="text" class="widefat image-url" value="<?php echo $headerbg; ?>" /><br />
            <a class="banner-upload" name="add" href="#">Upload Image</a> &nbsp; 
            <a class="banner-remove" name="remove" href="#" <?php echo ( ! $headerbg ? 'style="display:none;"' : '' ); ?>>Remove Image</a></p>
        </div>
        <div class="field-row" style="width:49%; float:left;">
            <div style="float:left; width:35%; margin-right:3%;">
                <p class="fld"><strong>Background color</strong></p>
                <p><input class="widefat" type="text" id="headerbg-color" name="headerbg-color" value="<?php echo $headerbg_color; ?>">
                <br /><span>eg. #ff00ff</span></p>
            </div>
            <div style="float:left; width:35%; margin-right:3%;">
                <p class="fld"><strong>Max Height</strong></p>
                <p><input class="widefat" type="text" id="headerbg-height" name="headerbg-height" value="<?php echo $headerbg_height; ?>">
                <br /><span>eg. 500px</span></p>
			</div>
            <div style="float:left; width:24%;">
                <p class="fld"><strong>Title Align</strong></p>
                <p><select style="margin-top:-1px;"  class="widefat" id="title-position" name="title-position">
                    <option value="left"<?php if ($title_position == 'left') echo ' selected="selected"';?>>Left</option>
                    <option value="right"<?php if ($title_position == 'right') echo ' selected="selected"';?>>Right</option>
                    <option value="center"<?php if ($title_position == 'center') echo ' selected="selected"';?>>Center</option>
                </select></p>
            </div>
        </div>
        <?php if ($headerOption == 'advanced') : ?>
        <hr style="clear:both;" />
        <div class="field-row" style="width:49%; margin-right:2%; float:left;">
            <div style="width:49%; margin-right:2%; float:left;">
                <p class="fld"><strong>Header Style</strong></p>
                <p><select style="min-width:100px;" class="nonfat" id="header-style" name="header-style">
                    <option value="style0"<?php if ($header_style == 'style0') echo ' selected="selected"';?>>Global - Theme Options</option>
                    <option value="style1"<?php if ($header_style == 'style1') echo ' selected="selected"';?>>Regular</option>
                    <option value="style2"<?php if ($header_style == 'style2') echo ' selected="selected"';?>>Transparent</option>
                    <option value="style3"<?php if ($header_style == 'style3') echo ' selected="selected"';?>>Hide Header</option>
                </select></p>
                <p class="fld"><strong>Sticky Header</strong></p>
                <p><select style="min-width:100px;" class="nonfat" id="header-sticky" name="header-sticky">
                    <option value="no"<?php if ($header_sticky == 'no') echo ' selected="selected"';?>>No</option>
                    <option value="yes"<?php if ($header_sticky == 'yes') echo ' selected="selected"';?>>Yes</option>
                </select></p>
            </div>
            <div style="width:49%; float:left;">
            <p class="fld"><strong>Transparent Skin</strong></p>
            <p><select style="min-width:100px;" class="nonfat" id="header-skin" name="header-skin">
                <option value="dark"<?php if ($header_skin == 'dark') echo ' selected="selected"';?>>Dark</option>
                <option value="light"<?php if ($header_skin == 'light') echo ' selected="selected"';?>>Light</option>
            </select>
            <select style="min-width:70px;" class="nonfat" id="header-trans" name="header-trans">
                <option value="100"<?php if ($header_trans == '100') echo ' selected="selected"';?>>100%</option>
                <option value="90"<?php if ($header_trans == '90') echo ' selected="selected"';?>>90%</option>
                <option value="80"<?php if ($header_trans == '80') echo ' selected="selected"';?>>80%</option>
                <option value="70"<?php if ($header_trans == '70') echo ' selected="selected"';?>>70%</option>
                <option value="60"<?php if ($header_trans == '60') echo ' selected="selected"';?>>60%</option>
                <option value="50"<?php if ($header_trans == '50') echo ' selected="selected"';?>>50%</option>
                <option value="40"<?php if ($header_trans == '40') echo ' selected="selected"';?>>40%</option>
                <option value="30"<?php if ($header_trans == '30') echo ' selected="selected"';?>>30%</option>
                <option value="20"<?php if ($header_trans == '20') echo ' selected="selected"';?>>20%</option>
                <option value="10"<?php if ($header_trans == '10') echo ' selected="selected"';?>>10%</option>
                <option value="0"<?php if ($header_trans == '0') echo ' selected="selected"';?>>0%</option>
            </select></p>
            <p class="fld"><strong>Topbar in Sticky</strong></p>
            <p><select style="min-width:100px;"  class="nonfat" id="header-tophide" name="header-tophide">
                <option value="hide"<?php if ($header_tophide == 'hide') echo ' selected="selected"';?>>Hide</option>
                <option value="show"<?php if ($header_tophide == 'show') echo ' selected="selected"';?>>Show</option>
            </select></p>
            </div>
            <br style="clear:both;" />
        </div>
        <div class="field-row" style="width:49%; float:left;">
            <p class="fld"><strong>Button Text:</strong></p>
            <p><input class="widefat" type="text" id="header-btntxt" name="header-btntxt" value="<?php echo $header_btntxt; ?>"></p>
            <p class="fld"><strong>Button Link:</strong> &nbsp; &nbsp; &nbsp; 
            <input type="checkbox" id="header-btntab" name="header-btntab" <?php checked( $header_btntab, 'on' ); ?> /> New Tab</p>
            <p><input class="widefat" type="text" id="header-btnurl" name="header-btnurl" value="<?php echo $header_btnurl; ?>">
            <br /><span>eg. http://www.yoursite.com/contact/</span></p>
        </div>
        <?php endif; ?>
    </div>
	<script type="text/javascript">
    jQuery(document).ready(function() {
        jQuery(".banner-upload").click(function(){ addImage(this, 'auto', 'auto'); return false; });
        jQuery(".banner-remove").click(function(){ removeImage(this, ''); return false; });
    });
    </script>
	<?php	
}
add_action( 'save_post', 'headermeta_save' );
function headermeta_save( $post_id ) {
    global $headerOption;
    if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
    if( !isset( $_POST['headermeta_box_nonce'] ) || !wp_verify_nonce( $_POST['headermeta_box_nonce'], 'headermeta_meta_box_nonce' ) ) return;
    if( !current_user_can( 'edit_post', $post_id ) ) return;
    $allowed = array( 'a' => array( 'href' => array() ) );
    // Update Meta
    $meta_field = array( 'headerbg', 'main-title', 'sub-title', 'headerbg-color', 'headerbg-height', 'title-position' );
    foreach ($meta_field as $field) {
        if (!empty($field) && isset($_POST[$field]))
            update_post_meta($post_id, $field, $_POST[$field]);
    }
    // For Advanced
    if ($headerOption == 'advanced') {
        // Update Meta
        $meta_field2 = array( 'header-style', 'header-sticky', 'header-trans', 'header-skin', 'header-tophide', 'header-btntxt', 'header-btnurl' );
        foreach ($meta_field2 as $field) {
            if (!empty($field) && isset($_POST[$field]))
                update_post_meta($post_id, $field, $_POST[$field]);
        }
        $header_btntab = ( isset( $_POST['header-btntab'] ) && $_POST['header-btntab'] ) ? 'on' : 'off';
        update_post_meta( $post_id, 'header-btntab', $header_btntab );
    }
}