<?php
/* @package ThemeNio
 * @copyright ThemeNio
 * @version 1.6.2.1
 * @updated 150830#iO
 * @tags post-type for wordpress
 *
 * !Important Note: All the meta-box function initialize into theme-posttype.php (which is found in inc folder)
 *
**/
## Sliders @since 1.2 @version 1.3 @update 020116 @by iO
function slides_register() {  
	$labels = array(
		'name' => __('Sliders'),
		'singular_name' => __('Slider'),
		'add_new' => __('Add Slider'),
		'add_new_item' => __('New Slider'),
		'edit_item' => __('Edit Slider'),
		'new_item' => __('New Slider'),
		'view_item' => __('View Sliders'),
		'search_items' => __('Search Slider'),
		'not_found' =>  __('Nothing found'),
		'not_found_in_trash' => __('Nothing found in Trash'),
		'parent_item' => __( 'Parent Sliders' ),
		'parent_item_colon' => __( 'Parent Sliders:' )
	);
	
    $args = array(  
        'labels' => $labels,  
        'public' => true,
        'show_ui' => true,  
        'capability_type' => 'post',  
        'hierarchical' => false,
        'rewrite' => false, 
		'query_var' => true,
		'menu_icon' => get_stylesheet_directory_uri() . '/inc/assets/icon-slider.png',
		'menu_position' => 4,
        'supports' => array('title', 'editor', 'thumbnail', 'page-attributes')  
    );  
    register_post_type( 'slides' , $args ); 
	
	// Initialize Category 
	$groups = array(  
		'name' => __( 'Groups'),  
		'singular_name' => __( 'Group'),  
		'search_items' =>  __( 'Search Group' ),  
		'all_items' => __( 'All Group' ),  
		'parent_item' => __( 'Parent Group' ),  
		'parent_item_colon' => __( 'Parent Group:' ),  
		'edit_item' => __( 'Edit Group' ),  
		'update_item' => __( 'Update Group' ),  
		'add_new_item' => __( 'Add Group' ),  
		'new_item_name' => __( 'New Group' ),  
	);
	register_taxonomy("groups", array("slides"), 
		array(
		'hierarchical'	=> true, 
		'show_ui'		=> true,
		'labels' 		=> $groups, 
		'query_var' 	=> true, 
		'rewrite' 		=> true	)
	);
	add_action("admin_init", "slides_meta");   
	function slides_meta(){  
		add_meta_box('slides_meta_box', 'Slides Options', 'slides_meta_opt', 'slides', 'normal', 'low');  
	}
	function slides_meta_opt($post_id){
        global $post;
        if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) return $post_id;
        $custom = get_post_custom($post->ID);
		// META FIELD
        $link_slide = isset($custom["link_slide"]) ? $custom["link_slide"][0] : '';
        $link_target = isset($custom["link_target"]) ? $custom["link_target"][0] : '';
        $slide_caption = isset($custom["slide_caption"]) ? $custom["slide_caption"][0] : '';
        $btn_text = isset($custom["btn_text"]) ? $custom["btn_text"][0] : '';
        $btn_link = isset($custom["btn_link"]) ? $custom["btn_link"][0] : '';
        $btn_target = isset($custom["btn_target"]) ? $custom["btn_target"][0] : '';
		$slide_color =  isset($custom['slide_color']) ? $custom['slide_color'][0] : '';
		$slide_bgcolor =  isset($custom['slide_bgcolor']) ? $custom['slide_bgcolor'][0] : '';
		$slide_class =  isset($custom['slide_class']) ? $custom['slide_class'][0] : '';
		$slide_align =  isset($custom['slide_align']) ? $custom['slide_align'][0] : '';
		$slide_position =  isset($custom['slide_position']) ? $custom['slide_position'][0] : '';
	?>
    <div class="inside-x" style="overflow:hidden;">
        <div style="float:left; width:49%; margin-right:2%;">
            <div style="float:left; width:100%;">
                <p><strong>Button Text</strong><br />
                <input class="widefat" type="text" name="btn_text" value="<?php echo $btn_text; ?>" placeholder="Read More" /></p>
                <p><strong>Button Link</strong><br />
                <input class="widefat" type="text" name="btn_link" value="<?php echo $btn_link; ?>" placeholder="http://" /><br />
                Open with &nbsp; &nbsp; <input type="radio" name="btn_target" value="same_page"<?php if ($btn_target == 'same_page') {echo ' checked="checked"';} else {echo ' checked="checked"';} ?> /> Same Tab &nbsp; &nbsp; &nbsp; 
                <input type="radio" name="btn_target" value="new_page"<?php if ($btn_target == 'new_page') echo ' checked="checked"'; ?> /> New Tab</p>
                <p><strong>Featured Image Link</strong><br />
                <input class="widefat" type="text" name="link_slide" value="<?php echo $link_slide; ?>" placeholder="http://"  /><br />
                Open with &nbsp; &nbsp; <input type="radio" name="link_target" value="same_page"<?php if ($link_target == 'same_page') {echo ' checked="checked"';} else {echo ' checked="checked"';} ?> /> Same Tab &nbsp; &nbsp; &nbsp; 
                <input type="radio" name="link_target" value="new_page"<?php if ($link_target == 'new_page') echo ' checked="checked"'; ?> /> New Tab</p>
            </div>
        </div>
        <div style="float:left; width:49%;">
            <div style="float:left; width:48%; margin-right:2%;">
            <p><strong style="display:inline-block; margin-bottom:4px;">Caption (Individual)</strong><br />
            <input type="radio" name="slide_caption" value="show"<?php if ($slide_caption == 'show') {echo ' checked="checked"';} else {echo ' checked="checked"';} ?> /> Show &nbsp; &nbsp; &nbsp; <input type="radio" name="slide_caption" value="hide"<?php if ($slide_caption == 'hide') echo ' checked="checked"'; ?> /> Hide</p>
            </div>
            <div style="float:left; width:48%; margin-left:2%;">
                <p><strong>Custom Class</strong><br />
                <input class="widefat" type="text" name="slide_class" value="<?php echo $slide_class; ?>" /></p>
            </div>
            <div style="float:left; width:48%; margin-right:2%;">
                <p><label for="slide_align"><strong>Text Alignment</strong></label><br />
                <select name="slide_align" style="width:100%">
                    <option<?php if($slide_align == 'left' || $slide_align == '') echo ' selected="left"'; ?> value="left">Left</option>
                    <option<?php if($slide_align == 'right') echo ' selected="selected"'; ?> value="right">Right</option>
                    <option<?php if($slide_align == 'center') echo ' selected="center"'; ?> value="center">Center</option>
                </select></p>
                <p><label for="slide_position"><strong>Block Position</strong></label><br />
                <select name="slide_position" style="width:100%">
                <option<?php if($slide_position=='lm lx vm' || $slide_position=='') echo ' selected="selected"';?> value="lm lx vm">Left Middle</option>
                <option<?php if($slide_position=='lb lx vb') echo ' selected="selected"'; ?> value="lb lx vb">Left Bottom</option>
                <option<?php if($slide_position=='lt lx vt') echo ' selected="selected"'; ?> value="lt lx vt">Left Top</option>
                <option<?php if($slide_position=='rm rx vm') echo ' selected="selected"'; ?> value="rm rx vm">Right Middle</option>
                <option<?php if($slide_position=='rb rx vb') echo ' selected="selected"'; ?> value="rb rx vb">Right Bottom</option>
                <option<?php if($slide_position=='rt rx vt') echo ' selected="selected"'; ?> value="rt rx vt">Right Top</option>
                <option<?php if($slide_position=='cm cx vm') echo ' selected="selected"'; ?> value="cm cx vm">Center Middle</option>
                <option<?php if($slide_position=='cb cx vb') echo ' selected="selected"'; ?> value="cb cx vb">Center Bottom</option>
                <option<?php if($slide_position=='ct cx vt') echo ' selected="selected"'; ?> value="ct cx vt">Center Top</option>
                </select></p>
            </div>
            <div style="float:left; width:48%; margin-left:2%;">
                <p><label for="slide_color"><strong>Text Color</strong></label><br />
                <select name="slide_color" style="width:100%">
                    <option<?php if($slide_color == 'light' || $slide_color == '') echo ' selected="selected"'; ?> value="light">Light</option>
                    <option<?php if($slide_color == 'dark') echo ' selected="dark"'; ?> value="dark">Dark</option>
                </select></p>
                <p><label for="slide_bgcolor"><strong>Block Background</strong></label><br />
                <select name="slide_bgcolor" style="width:100%">
                <option<?php if($slide_bgcolor == 'dark' || $slide_bgcolor == '') echo ' selected="dark"'; ?> value="dark">Dark</option>
                <option<?php if($slide_bgcolor == 'light') echo ' selected="selected"'; ?> value="light">Light</option>
                <option<?php if($slide_bgcolor == 'none') echo ' selected="none"'; ?> value="none">None</option>
                </select></p>
            </div>
        </div>
        <div style="clear:both;"></div>
        <p>All the options may not works properly in current theme. Ask your web developer if you face problem.</p>
    </div>
	<?php 
	}
}  
    
add_action('save_post', 'save_slides'); 
function save_slides($post_id){
    global $post;
    if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ){
		return $post->ID;
	}else{
		// Update Meta
		$meta_field = array( 'link_slide', 'link_target', 'slide_caption', 'btn_text', 'btn_link', 'btn_target', 'slide_color', 'slide_bgcolor', 'slide_class', 'slide_align', 'slide_position' );
		foreach ($meta_field as $field) {
			if (!empty($field) && isset($_POST[$field]))
			update_post_meta($post_id, $field, $_POST[$field]);
		}
    }
}
add_filter("manage_edit-slides_columns", "slides_edit_columns");   
function slides_edit_columns($columns){  
        $columns = array(  
            "cb" => "<input type=\"checkbox\" />",  
            "title" => "Title",  
            "slides-desc" => "Description", 
            "slides-thumb" => "Photo", 
            "slides-group" => "Groups", 
        );  
  
        return $columns;  
}  
add_action("manage_posts_custom_column",  "slides_custom_columns"); 
function slides_custom_columns($column){  
	global $post;  
	switch ($column) {  
		case "slides-desc":  
			the_excerpt();  
			break;
		case "slides-group":  
			echo get_the_term_list($post->ID, 'groups', '', ', ','');
			break;  
		case "slides-thumb":  
			if ( has_post_thumbnail() ) : 
				the_post_thumbnail(array(120, 80)); 
			else : 
			echo 'No Image';
			endif;
			break;
	}  
}
## Logos @since 1.6 @version 1.1 @update 090115 @by iO
function logos_register() {
	$labels = array(
		'name' => __('Logos', 'post type general name'),
		'singular_name' => __('Logos', 'post type singular name'),
		'add_new' => __('Add Logo', 'location item'),
		'add_new_item' => __('Add Logo'),
		'edit_item' => __('Edit Logo'),
		'new_item' => __('New Logo'),
		'view_item' => __('View Logo'),
		'search_items' => __('Search Logos'),
		'not_found' =>  __('Nothing found'),
		'not_found_in_trash' => __('Nothing found in Trash'),
		'parent_item' => __( 'Parent Logos' ),
		'parent_item_colon' => __( 'Parent Logos:' )
	);
	
    $args = array(  
        'labels' => $labels,  
        'public' => true,
		'publicly_queryable' => true,
        'show_ui' => true,  
        'capability_type' => 'post',  
        'hierarchical' => false,
		'has_archive' => false,
		'rewrite' =>  array('slug' => 'partner', 'with_front' => false ),
		'query_var' => true,
		'menu_icon' => get_stylesheet_directory_uri() . '/inc/assets/icon-logo.png',
		'menu_position' => 5,
        'supports' => array('title', 'editor', 'thumbnail', 'page-attributes')  
	);  
	// Initialize Category Labels  
	$logo_cat = array(  
		'name' => _x( 'Categories', 'taxonomy general name' ),  
		'singular_name' => _x( 'Category', 'taxonomy singular name' ),  
		'search_items' =>  __( 'Search Category' ),  
		'all_items' => __( 'All Category' ),  
		'parent_item' => __( 'Parent Category' ),  
		'parent_item_colon' => __( 'Parent Category:' ),  
		'edit_item' => __( 'Edit Category' ),  
		'update_item' => __( 'Update Category' ),  
		'add_new_item' => __( 'Add New Category' ),  
		'new_item_name' => __( 'New Category' ),  
	);
	register_taxonomy("logo-cat", array("logo"), 
		array(
		'hierarchical'	=> true, 
		'show_ui'		=> true,
		'labels' 		=> $logo_cat, 
		'query_var' 	=> true, 
		'rewrite' 		=> true
		)
	);
	
    register_post_type( 'logo' , $args ); 
	flush_rewrite_rules();
	// Postion switch
	add_action('do_meta_boxes', 'logo_default_box');
	function logo_default_box() {
		remove_meta_box( 'postimagediv', 'logo', 'side' );
		add_meta_box('postimagediv', __('Logo Image'), 'post_thumbnail_meta_box', 'logo', 'normal', 'high');
		remove_meta_box( 'pageparentdiv', 'logo', 'side' );
		add_meta_box('pageparentdiv', __('Logo Order'), 'page_attributes_meta_box', 'logo', 'normal', 'low');
	}
	// Meta-box
	add_action("admin_init", "logos_meta");   
	function logos_meta(){  
		add_meta_box('logos_meta_box', 'Logo Information', 'logos_meta_opt', 'logo', 'normal', 'core');  
	}
	function logos_meta_opt($post_id){  
        global $post;  
        if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) return $post_id;
        $custom = get_post_custom($post->ID);  
        $logo_url = isset($custom["logo-url"]) ? $custom["logo-url"][0] : '';
	?>  
    <p><strong>Logo URL (external)</strong><br />
    <input class="widefat" type="text" id="logo-url" name="logo-url" value="<?php echo $logo_url; ?>"></p>
    <style type="text/css">
		#postdivrich, #titlewrap+.inside {display:none;}
	</style>
	<?php
	}
} 
add_action('save_post', 'save_logos');   
function save_logos($post_id){
    global $post;
    if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ){
		return $post_id;
	}else{
		// Update Meta
		$meta_field = array( 'logo-url' );
		foreach ($meta_field as $field) {
			if (!empty($field) && isset($_POST[$field]))
			update_post_meta($post_id, $field, $_POST[$field]);
		}
    }
} 
add_filter("manage_edit-logo_columns", "logo_edit_columns");   
function logo_edit_columns($columns){  
        $columns = array(  
            "cb" => "<input type=\"checkbox\" />",  
            "title" => "Name / Title",  
            "logo-thumb" => "Thumbs", 
            "logo-cats" => "Categories", 
        );  
        return $columns;  
}  
add_action("manage_posts_custom_column",  "logo_custom_columns"); 
function logo_custom_columns($column){  
        global $post;  
        switch ($column)  
        {  
			case "logo-cats":  
                echo get_the_term_list($post->ID, 'logo-cat', '', ', ','');
                break; 
			case "logo-thumb":  
                if ( has_post_thumbnail() ) : 
					the_post_thumbnail(array(140, 60)); 
				else :  echo 'No Logo';
				endif;
                break;
        }  
}
## Testimonal/Quotes @since 1.5 @version 1.2 @update 090115 @by iO
function quotes_register() {  
	$labels = array(
		'name' => __('Quotes'),
		'singular_name' => __('Quote'),
		'add_new' => __('Add Quote'),
		'add_new_item' => __('Add Quote'),
		'edit_item' => __('Edit Quote'),
		'new_item' => __('New Quotes'),
		'view_item' => __('View Quotes'),
		'search_items' => __('Search Quotes'),
		'not_found' =>  __('Nothing found'),
		'not_found_in_trash' => __('Nothing found in Trash'),
		'parent_item' => __( 'Parent Quotes' ),
		'parent_item_colon' => __( 'Parent Quotes:' )
	);
	
    $args = array(  
		'labels' => $labels,  
		'public' => true,  
		'show_ui' => true,  
		'capability_type' => 'post',  
		'hierarchical' => false,
		'has_archive' => false,
		'rewrite' =>  array('slug' => 'testimonial', 'with_front' => false ),
		'query_var' => true,
		'menu_icon' => get_stylesheet_directory_uri() . '/inc/assets/icon-quote.png',
		'menu_position' => 6,
		'supports' => array('title', 'editor', 'thumbnail', 'revisions')  
	);  
  
    register_post_type( 'quote' , $args ); 
	flush_rewrite_rules();
	
	add_action("admin_init", "quote_meta");   
	function quote_meta(){  
		add_meta_box('quote_meta_box', 'Quote Information', 'quote_meta_opt', 'quote', 'normal', 'high');  
	}

	function quote_meta_opt(){  
        global $post;  
        if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) return $post_id;
        $custom = get_post_custom($post->ID);  
        $quote_heading 	= isset($custom["quote-heading"]) ? $custom["quote-heading"][0] : '';
        $quote_author 	= isset($custom["quote-author"]) ? $custom["quote-author"][0] : '';
        $quote_position = isset($custom["quote-position"]) ? $custom["quote-position"][0] : '';
        $quote_company 	= isset($custom["quote-company"]) ? $custom["quote-company"][0] : '';
        $quote_website 	= isset($custom["quote-website"]) ? $custom["quote-website"][0] : '';
        $quote_color 	= isset($custom["quote-color"]) ? $custom["quote-color"][0] : '';
        $quote_colorx 	= isset($custom["quote-colorx"]) ? $custom["quote-colorx"][0] : '';
        $quote_ratings 	= isset($custom["quote-ratings"]) ? $custom["quote-ratings"][0] : '';
	?>  

    <div class="inside-x" style="overflow:hidden;">
        <div style="float:left; width:100%;">
            <p>Quote Heading/Highligted Comment</p>
            <p><textarea class="widefat" name="quote-heading" style="height:80px;"><?php echo $quote_heading; ?></textarea></p>
        </div>
        <div style="float:left; width:49%; margin-right:1%;">
            <p>Name <small> (Who Quote) </small></p>
            <p><input class="widefat" type="text" name="quote-author" value="<?php echo $quote_author; ?>" /></p>
        </div>
        <div style="float:left; width:49%; margin-left:1%;">
            <p>Position/Title</p>
            <p><input class="widefat" type="text" name="quote-position" value="<?php echo $quote_position; ?>" /></p>
        </div>
        <div style="float:left; width:49%; margin-right:1%;">
            <p>Company Name</p>
            <p><input class="widefat" type="text" name="quote-company" value="<?php echo $quote_company; ?>" /></p>
        </div>
        <div style="float:left; width:49%; margin-left:1%;">
            <p>Company Website <small>External</small></p>
            <p><input class="widefat" type="text" name="quote-website" value="<?php echo $quote_website; ?>" placeholder="http://" /></p>
        </div>
        <div style="float:left; width:49%; margin-right:1%;">
            <p>Scheme Color</p>
            <p><select name="quote-color" class="widefat" style="width:40%; margin-right:10px;">
                <option value="default"<?php if($quote_color=='default') echo ' selected';?>>Default</option>
            </select>
    		<span style="display:none;">
            &nbsp; OR &nbsp; <input style="width:30%;" class="inp" type="text" maxlength="6" id="quote-colorx" name="quote-colorx" value="<?php echo $quote_colorx; ?>" /> (#00ff00)</span></p>
        </div>
        <div style="float:left; width:49%; margin-left:1%;">
            <p>Company Ratings</p>
			<select name="quote-ratings" style="width:30%;">
				<option value="1" <?php if($quote_ratings == '1') echo ' selected'; ?>>1</option>
				<option value="2" <?php if($quote_ratings == '2') echo ' selected'; ?>>2</option>
				<option value="3" <?php if($quote_ratings == '3') echo ' selected'; ?>>3</option>
				<option value="4" <?php if($quote_ratings == '4') echo ' selected'; ?>>4</option>
				<option value="5" <?php if($quote_ratings == '5') echo ' selected'; ?>>5</option>
			</select>
        </div>
    </div>
	<?php 
	}
} 
add_action('save_post', 'save_quote');   
function save_quote($post_id){
    global $post;
    if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ){
		return $post_id;
	}else{
		// Update Meta
		$meta_field = array( 'quote-heading', 'quote-author', 'quote-position', 'quote-company', 'quote-website', 'quote-color', 'quote-colorx', 'quote-ratings' );
		foreach ($meta_field as $field) {
			if (!empty($field) && isset($_POST[$field]))
			update_post_meta($post_id, $field, $_POST[$field]);
		}
    }
}
add_filter("manage_edit-quote_columns", "quote_edit_columns");   
function quote_edit_columns($columns){  
        $columns = array(  
            "cb" => "<input type=\"checkbox\" />",  
            "title" => "Name / Title",  
            "quote-desc" => "Quotation/Testimonial",
            "quote-thumb" => "Thumbnail",
        );  
        return $columns;  
}  
add_action("manage_posts_custom_column",  "quote_custom_columns"); 
function quote_custom_columns($column){  
        global $post;  
        switch ($column)  
        {  
            case "quote-desc": 
				if (mo('quote-heading') !='') {
                echo '<strong>'.excerpt_title(10, mo('quote-heading')).'</strong><br> '.excerpt(10);
				} else {
                echo excerpt(20);
				}
                break;  
			case "quote-thumb": 
				if ( has_post_thumbnail() ) : 
					the_post_thumbnail(array (80, 80)); 
				else : echo 'No image';
				endif;
                break;
        }  
}
## Teams/Staffs @since 1.6 @version 1.1 @update 090115 @by iO
function teams_register() {  
	$labels = array(
		'name' => __('Teams'),
		'singular_name' => __('Team'),
		'add_new' => __('Add Team'),
		'add_new_item' => __('Add Team'),
		'edit_item' => __('Edit Team'),
		'new_item' => __('New Team'),
		'view_item' => __('View Team'),
		'search_items' => __('Search Teams'),
		'not_found' =>  __('Nothing found'),
		'not_found_in_trash' => __('Nothing found in Trash'),
		'parent_item' => __( 'Parent Teams' ),
		'parent_item_colon' => __( 'Parent Teams:' )
	);
	
    $args = array(  
        'labels' => $labels,  
        'public' => true,  
        'show_ui' => true,  
        'capability_type' => 'post',  
        'hierarchical' => false,
		'has_archive' => false,
		'rewrite' =>  true,
		'query_var' => true,
		'menu_icon' => get_stylesheet_directory_uri() . '/inc/assets/icon-team.png',
		'menu_position' => 6,
        'supports' => array('title', 'editor', 'thumbnail', 'revisions', 'page-attributes')  
	);  
  
	
	// Initialize Category Labels  
	$team_cat = array(  
		'name' => _x( 'Departments', 'taxonomy general name' ),  
		'singular_name' => _x( 'Department', 'taxonomy singular name' ),  
		'search_items' =>  __( 'Search Department' ),  
		'all_items' => __( 'All Department' ),  
		'parent_item' => __( 'Parent Department' ),  
		'parent_item_colon' => __( 'Parent Department:' ),  
		'edit_item' => __( 'Edit Department' ),  
		'update_item' => __( 'Update Department' ),  
		'add_new_item' => __( 'Add New Department' ),  
		'new_item_name' => __( 'New Department' ),  
	);
 
	register_taxonomy("team-dept", array("team"), 
		array(
		'hierarchical'	=> true, 
		'show_ui'		=> true,
		'labels' 		=> $team_cat, 
		'query_var' 	=> true, 
		'rewrite' 		=> true
		)
	); 
    register_post_type( 'team' , $args ); 
	flush_rewrite_rules();
	add_action("admin_init", "team_info");   
	function team_info(){  
		add_meta_box('team_info_meta', 'Team Information', 'team_info_fnc', 'team', 'normal', 'low');  
	}
	function team_info_fnc($post_id){  
        global $post;  
        if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) return $post_id;
        $custom = get_post_custom($post->ID);  
        $team_title = isset($custom["team-title"]) ? $custom["team-title"][0] : '';
        $team_email = isset($custom["team-email"]) ? $custom["team-email"][0] : '';
        $team_fb = isset($custom["team-fb"]) ? $custom["team-fb"][0] : '';
        $team_tw = isset($custom["team-tw"]) ? $custom["team-tw"][0] : '';
        $team_in = isset($custom["team-in"]) ? $custom["team-in"][0] : '';
        $team_gp = isset($custom["team-gp"]) ? $custom["team-gp"][0] : '';
	?>  



    <div class="inside-x" style="overflow:hidden;">
    	<div style="float:left; margin-right:1%; width:49%;">
        <p><strong>Title / Position</strong><br />
        <input class="widefat" type="text" id="team-title" name="team-title" value="<?php echo $team_title; ?>"></p>
        </div>
    	<div style="float:left; margin-left:1%; width:49%;">
        <p><strong>Email</strong><br />
        <input class="widefat" type="text" id="team-email" name="team-email" value="<?php echo $team_email; ?>"></p>
        </div>
    	<div style="float:left; margin-right:1%; width:49%;">
        <p><strong>Facebook Profile</strong><br />
        <input class="widefat" type="text" id="team-fb" name="team-fb" value="<?php echo $team_fb; ?>"></p>
        <p><strong>Twitter Profile</strong><br />
        <input class="widefat" type="text" id="team-tw" name="team-tw" value="<?php echo $team_tw; ?>"></p>
        </div>
        
    	<div style="float:left; margin-left:1%; width:49%;">
        <p><strong>Linkedin Profile</strong><br />
        <input class="widefat" type="text" id="team-in" name="team-in" value="<?php echo $team_in; ?>"></p>
        <p><strong>Google+ Profile</strong><br />
        <input class="widefat" type="text" id="team-gp" name="team-gp" value="<?php echo $team_gp; ?>"></p>
        </div>
    </div>
	<?php 
	}
} 
// Save
add_action('save_post', 'save_team');   
function save_team($post_id){
    global $post;
    if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ){
		return $post_id;
	}else{
		// Update Meta
		$meta_field = array( 'team-title', 'team-email', 'team-fb', 'team-tw', 'team-in', 'team-gp' );
		foreach ($meta_field as $field) {
			if (!empty($field) && isset($_POST[$field]))
			update_post_meta($post_id, $field, $_POST[$field]);
		}
    }
}
add_filter("manage_edit-team_columns", "team_edit_columns");   
function team_edit_columns($columns){  
        $columns = array(  
            "cb" => "<input type=\"checkbox\" />",  
            "title" => "Name / Title",  
            "team-thumb" => "Photo", 
            "team-dept" => "Departments", 
        );  
        return $columns;  
}  
add_action("manage_posts_custom_column",  "team_custom_columns"); 
function team_custom_columns($column){  
        global $post;  
        switch ($column)  
        {  
			case "team-dept":  
                echo get_the_term_list($post->ID, 'team-dept', '', ', ', '');
                break; 
			case "team-thumb":  
                if ( has_post_thumbnail() ) : the_post_thumbnail(array(100, 80)); else : echo 'No Photo'; endif;
                break;
        }  
}
