<?php
/* @package ThemeNio
 * @copyright ThemeNio
 * @version 1.6.2.1
 * @updated 150830#iO
 * @tags shortcode for wordpress
 *
 * !Important Note: All the shortcode function initialize into theme-shortcode.php (which is found in inc folder)
 *
**/
## empty_remove @since 1.1
function empty_remove( $content ){
	return str_replace( array( '<p></p>', '<p> </p>', '<p>&nbsp;</p>' ), '', $content );
}
## clean @since 1.1
function clean( $content ) {
	$content = shortcode_unautop( $content );
	if ( substr( $content, 0, 4 ) == '</p>' )
		$content = substr( $content, 4 );
	if ( substr( $content, -3, 3 ) == '<p>' )
		$content = substr( $content, 0, -3 );
	return empty_remove( $content );
}
## section @since 1.2 @version 1.3 @update 120615 @by iO
function nio_section($atts, $content = null) {
    extract(shortcode_atts(array(
		'id' => '',
		'ui' => '',
        'name' => 'regular',
		'top' => '',
		'bottom' => '',
		'bgcolor' => '',
		'color' => '',
		'btop' => '',
		'bbottom' => '',
		'bg' => '',
		'parallax' => '',
		'style' => '',
		'height' => '',
		'on' => '',
		'off' => '',
		'animate' => '',
		'duration' => '',
		'delay' => '',	
		'arrow' => ''	
    ), $atts));
	
	$aniclass = '';
	if ($animate) {
		$aniclass = ' animated';
		$animate = ' data-animate="'.$animate.'"';
		if ($duration !='') {
			$duration = ' data-duration="'.$duration.'"';
		} else {
			$duration = ' data-duration="1"';
		}
		if ($delay)
			$delay = ' data-delay="'.$delay.'"';
	}
	$top_v = $bottom_v = 0;
	if ($top) $top_v = (int)str_replace('px', '', $top);
	if ($bottom) $bottom_v = (int)str_replace('px', '', $bottom);
	if($top || $bottom ) $aniclass .= ' has-pad';
	if($top_v > 600 ) $aniclass .= ' pad-t-lx';
	if($top_v >= 70 && $top_v <= 115 ) $aniclass .= ' pad-t-s';	
	if($top_v > 115 && $top_v <= 200 ) $aniclass .= ' pad-t-m';
	if($top_v > 200 && $top_v <= 400 ) $aniclass .= ' pad-t-l';
	if($top_v > 400 && $top_v <= 600 ) $aniclass .= ' pad-t-x';
	
	if($bottom_v > 600 ) $aniclass .= ' pad-b-lx';
	if($bottom_v >= 70 && $bottom_v <= 115 ) $aniclass .= ' pad-b-s';
	if($bottom_v > 115 && $bottom_v <= 200 ) $aniclass .= ' pad-b-m';
	if($bottom_v > 200 && $bottom_v <= 400 ) $aniclass .= ' pad-b-l';
	if($bottom_v > 400 && $bottom_v <= 600 ) $aniclass .= ' pad-b-x';
	if($btop || $bbottom ) $aniclass .= ' has-border';
	if($bg !='') $aniclass .= ' has-bg';
	if($parallax !='') $aniclass .= ' iparallax';
	if($style !='') $aniclass .= ' iparallax-'.$style;
    $out  = '';
	$nameclass = cssclass($name, 'section');
	if ($ui) $nameclass .= cssclass($ui, 'section'); 
	if ($on) $nameclass .= cssclass($on, 'on');
	if ($off) $nameclass .= cssclass($off, 'off');
	if ($arrow) $nameclass .= ' dir-'.$arrow;
	
	$out .= '<div class="section container-section'.$nameclass.$aniclass.'"';
	if($parallax !='' && ($style == 'style1' || $style == 'style2') ) {
		$out .= '<div class="parallax-overlay overlay-'.$style.'" style="background-image:url('.$parallax.');"><span><img src="'.$parallax.'" alt="" /></span></div>';		
	}
	if ($id) $out .= ' id="'.$id.'"';
	if ($top || $bottom || $btop || $bbottom || $bgcolor || $color || $parallax || $bg || $height ) {
		$out .= ' style="';
		if ($top) $out .= 'padding-top:'.$top.';';
		if ($bottom) $out .= 'padding-bottom:'.$bottom.';';
		if ($btop) $out .= 'border-top:'.$btop.';';
		if ($bbottom) $out .= 'border-bottom:'.$bbottom.';';
		if ($bgcolor) $out .= 'background-color:'.$bgcolor.';';
		if ($color) $out .= 'color:'.$color.';';
		if ($height) $out .= 'height:'.$height.'px;';
		if($parallax !='' && $style == '') {
			$out .= ' background-image:url('.$parallax.');';
		} elseif ($bg !='')  {
			$out .= ' background-image:url('.$bg.');';
		}
		
		$out .= '"';		
	}
	$out .= ''.$animate.$duration.$delay.'>';
    $out .= do_shortcode(clean($content));
	if($parallax !='' && $style != '') {
		if ($style != 'style1' && $style != 'style2') {
			$out .= '<div class="parallax-overlay overlay-'.$style.'" style="background-image:url('.$parallax.');"><span><img src="'.$parallax.'" alt="" /></span></div>';		
		}
	} else if($parallax !='') {
		$out .= '<div class="parallax-overlay">&nbsp;</div>';
	}
	if($parallax=='' && $bg !='') {
		$out .= '<div class="bg-overlay">&nbsp;</div>';
	}
	$out .= '</div>';
    return $out;
}
## wrap @since 1.2 @version 1.2 @update 091515 @by iO
function nio_wrap($atts, $content = null) {
    extract(shortcode_atts(array(
        'name' => 'regular',
		'on' => '',
		'off' => '',
		'top' => '',
		'bottom' => '',
		'btop' => '',
		'bbottom' => ''
    ), $atts));
    $out  = '';
	$wrapclass = cssclass($name, 'wrap', '', false);
	if ($on) $wrapclass .= cssclass($on, 'on');
	if ($off) $wrapclass .= cssclass($off, 'off');
	$out .= '<div class="main wrap-section'.$wrapclass.'"';
	if ($top || $bottom || $btop || $bbottom ) {
		$out .= ' style="';
		if ($top) $out .= 'padding-top:'.$top.';';
		if ($bottom) $out .= 'padding-bottom:'.$bottom.';';
		if ($btop) $out .= 'border-top:'.$btop.';';
		if ($bbottom) $out .= 'border-bottom:'.$bbottom.';';
		$out .= '"';		
	}
	$out .= '>';
    $out .= '<div class="content grid12"><div class="inner-content">'.do_shortcode(clean($content)).'</div></div>';
	$out .= '</div>';
    return $out;
}
## section-wrap @since 1.2 @version 1.3 @update 120615 @by iO
function nio_section_wrap($atts, $content = null) {
    extract(shortcode_atts(array(
		'id' => '',
		'ui' => '',
        'name' => 'regular',
		'top' => '',
		'bottom' => '',
		'bgcolor' => '',
		'color' => '',
		'btop' => '',
		'bbottom' => '',
		'bg' => '',
		'parallax' => '',
		'style' => '',
		'height' => '',
		'on' => '',
		'off' => '',
		'animate' => '',
		'duration' => '',
		'delay' => '',
		'arrow' => ''
    ), $atts));
	
	$aniclass = '';
	if ($animate) {
		$aniclass = ' animated';
		$animate = ' data-animate="'.$animate.'"';
		if ($duration !='') {
			$duration = ' data-duration="'.$duration.'"';
		} else {
			$duration = ' data-duration="1"';
		}
		if ($delay)
			$delay = ' data-delay="'.$delay.'"';
	}
	$top_v = $bottom_v = 0;
	if ($top) $top_v = (int)str_replace('px', '', $top);
	if ($bottom) $bottom_v = (int)str_replace('px', '', $bottom);
	if($top || $bottom ) $aniclass .= ' has-pad';
	if($top_v > 600 ) $aniclass .= ' pad-t-lx';
	if($top_v >= 70 && $top_v <= 115 ) $aniclass .= ' pad-t-s';	
	if($top_v > 115 && $top_v <= 200 ) $aniclass .= ' pad-t-m';
	if($top_v > 200 && $top_v <= 400 ) $aniclass .= ' pad-t-l';
	if($top_v > 400 && $top_v <= 600 ) $aniclass .= ' pad-t-x';
	
	if($bottom_v > 600 ) $aniclass .= ' pad-b-lx';
	if($bottom_v >= 70 && $bottom_v <= 115 ) $aniclass .= ' pad-b-s';
	if($bottom_v > 115 && $bottom_v <= 200 ) $aniclass .= ' pad-b-m';
	if($bottom_v > 200 && $bottom_v <= 400 ) $aniclass .= ' pad-b-l';
	if($bottom_v > 400 && $bottom_v <= 600 ) $aniclass .= ' pad-b-x';
	
	if($btop || $bbottom ) $aniclass .= ' has-border';
	if($bg !='') $aniclass .= ' has-bg';
	if($parallax !='') $aniclass .= ' iparallax';
	if($style !='') $aniclass .= ' iparallax-'.$style;
    $out  = '';
	$nameclass = cssclass($name, 'section');
	$wrapclass = cssclass($name, 'wrap', '', false);
	if ($ui) $nameclass .= cssclass($ui, 'section'); 
	if ($on) $nameclass .= cssclass($on, 'on');
	if ($off) $nameclass .= cssclass($off, 'off');
	if ($arrow) $nameclass .= ' dir-'.$arrow;
	
	$out .= '<div class="section container-section'.$nameclass.$aniclass.'"';
	if ($id) $out .= ' id="'.$id.'"';
	if ($top || $bottom || $btop || $bbottom || $bgcolor || $color || $parallax || $bg || $height ) {
		$out .= ' style="';
		if ($top) $out .= 'padding-top:'.$top.';';
		if ($bottom) $out .= 'padding-bottom:'.$bottom.';';
		if ($btop) $out .= 'border-top:'.$btop.';';
		if ($bbottom) $out .= 'border-bottom:'.$bbottom.';';
		if ($bgcolor) $out .= 'background-color:'.$bgcolor.';';
		if ($color) $out .= 'color:'.$color.';';
		if ($height) $out .= 'height:'.$height.';';
		if($parallax !='' && $style == '') {
			$out .= ' background-image:url('.$parallax.');';
		} elseif ($bg !='')  {
			$out .= ' background-image:url('.$bg.');';
		}
		$out .= '"';		
	}
	$out .= ''.$animate.$duration.$delay.'>';
	if($parallax !='' && ($style == 'style1' || $style == 'style2') ) {
		$out .= '<div class="parallax-overlay overlay-'.$style.'" style="background-image:url('.$parallax.');"><span><img src="'.$parallax.'" alt="" /></span></div>';		
	}
	$out .= '<div class="main wrap-section'.$wrapclass.'">';
    $out .= '<div class="content grid12"><div class="inner-content">'.do_shortcode(clean($content)).'</div></div>';
	$out .= '</div>';
	if($parallax !='' && $style !='') {
		if ($style != 'style1' && $style != 'style2') {
			$out .= '<div class="parallax-overlay overlay-'.$style.'" style="background-image:url('.$parallax.');"><span><img src="'.$parallax.'" alt="" /></span></div>';		
		}
	} else if($parallax !='') {
		$out .= '<div class="parallax-overlay"></div>';
	}
	if($parallax=='' && $bg !='') {
		$out .= '<div class="bg-overlay">&nbsp;</div>';
	}
	$out .= '</div>';
    return $out;
}
## content-wrap / wrap-box @since 1.2 @version 1.2 @update 091515 @by iO
function nio_content_wrap($atts, $content = null) {
    extract(shortcode_atts(array(
		'id' => '',
        'name' => 'regular',
		'top' => '',
		'bottom' => '',
		'btop' => '',
		'bbottom' => '',
		'on' => '',
		'off' => '',
		'animate' => '',
		'duration' => '',
		'delay' => ''
    ), $atts));
	
	if ($id) $id = ' id="'.$id.'"';
	$aniclass = '';
	if ($animate) {
		$aniclass = ' animated';
		$animate = ' data-animate="'.$animate.'"';
		if ($duration !='') {
			$duration = ' data-duration="'.$duration.'"';
		} else {
			$duration = ' data-duration="1"';
		}
		if ($delay)
			$delay = ' data-delay="'.$delay.'"';
	}
    $out  = '';
	$nameclass = cssclass($name, 'content');
	if ($on) $nameclass .= cssclass($on, 'on');
	if ($off) $nameclass .= cssclass($off, 'off');
	$out .= '<div class="section content-box wrap-box'.$nameclass.$aniclass.'"';
	if ($top || $bottom || $btop || $bbottom ) {
		$out .= ' style="';
		if ($top) $out .= 'padding-top:'.$top.';';
		if ($bottom) $out .= 'padding-bottom:'.$bottom.';';
		if ($btop) $out .= 'border-top:'.$btop.';';
		if ($bbottom) $out .= 'border-bottom:'.$bbottom.';';
		$out .= '"';		
	}
	$out .= ''.$animate.$duration.$delay.$id.'>';
    $out .= '<div class="content-block"><div class="inner-content">'.do_shortcode(clean($content)).'</div></div>';
	$out .= '</div><div class="clr"></div>';
    return $out;
}
## boxed @since 1.2 @version 1.2 @update 091515 @by iO
function nio_boxed($atts, $content = null) {
    extract(shortcode_atts(array(
		'name' => 'basic',
		'grid' => '4',
		'top' => '',
		'bottom' => '',
		'left' => '',
		'right' => '',
		'firstlast' => '',
		'on' => '',
		'off' => '',
		'animate' => '',
		'duration' => '',
		'delay' => ''
    ), $atts));
	
    $out  = '';
	$nameclass = cssclass($name, 'ibox');
	if ($on) $nameclass .= cssclass($on, 'on');
	if ($off) $nameclass .= cssclass($off, 'off');
    if ($firstlast) $nameclass .= ' '.$firstlast;
	
	if ($animate) {
		$nameclass .= ' animated';
		$animate = ' data-animate="'.$animate.'"';
		if ($duration !='') {
			$duration = ' data-duration="'.$duration.'"';
		} else {
			$duration = ' data-duration="1"';
		}
		if ($delay)
			$delay = ' data-delay="'.$delay.'"';
	}
	
	$out .= '<div class="ibox grid'.$grid.$nameclass.'"'.$animate.$duration.$delay.'>';
    $out .= '<div class="content"';
	if ($top || $bottom || $right || $left ) {
		$out .= ' style="';
		if ($top) $out .= 'padding-top:'.$top.';';
		if ($bottom) $out .= 'padding-bottom:'.$bottom.';';
		if ($left) $out .= 'padding-left:'.$left.';';
		if ($right) $out .= 'padding-right:'.$right.';';
		$out .= '"';		
	}	
	$out .= '>';
	$out .= do_shortcode(clean($content));
	$out .= '</div>';
	$out .= '</div>';
    if ($firstlast == 'last')
	$out .= '<div class="clr"></div>';
    return $out;
}
## iconbox / icon-box @since 1.2 @version 1.2 @update 091515 @by iO
function nio_iconbox($atts, $content = null) {
    extract(shortcode_atts(array(
		'id' => '',
		'title' => '',
		'type' => 'icon',
		'icon' => '',
		'url' => '',
		'link' => '',
		'target' => '',
        'name' => '',
		'grid' => '',
		'style' => 'ui',
		'firstlast' => '',
		'on' => '',
		'off' => '',
		'animate' => '',
		'duration' => '',
		'delay' => ''
    ), $atts));
	
	$after_a = $before_a = '';
	if ($id) $id = ' id="'.$id.'"';
	if ($grid) { 
		$grid = ' grid-box grid'.$grid;
	} else {
		$grid = ' box-icon-basic';
	}
	if ($target == '_blank') {
		$target = ' target="_blank"';
	}
	if ($link) {
		$before_a = '<a href="'.$link.'"'.$target.'>';
		$after_a = '</a>';
	}
	if ($animate) {
		$name .= ' animated';
		$animate = ' data-animate="'.$animate.'"';
		if ($duration !='') {
			$duration = ' data-duration="'.$duration.'"';
		} else {
			$duration = ' data-duration="1"';
		}
		if ($delay)
			$delay = ' data-delay="'.$delay.'"';
	}
    $out  = '';
	$nameclass = cssclass($name, 'box-icon');
	$styleclass = cssclass($style, 'si');
	$stylex = cssclass($style, 'c');
	if ($on) $nameclass .= cssclass($on, 'on');
	if ($off) $nameclass .= cssclass($off, 'off');
    if ($firstlast) $nameclass .= ' '.$firstlast;
    $out = '<div class="box-icon box-type-'.$type.$grid.$nameclass.'"'.$animate.$duration.$delay.$id.'><div class="box-icon-block">';
	
	if ($type == 'icon' && $url !='') {
	$out .= '<div class="round type-icon'.$stylex.' user-icon"><div class="icon-x">'.$before_a.'<img src="'.$url.'" alt="'.$title.'" />'.$after_a.'</div></div>';
	} else if ($type == 'icon' && $icon !='') {
	$out .= '<div class="round type-icon'.$stylex.' theme-icon hover"><div class="icon-x">'.$before_a.'<span class="icon icon-'.$icon.$styleclass.'"></span>'.$after_a.'</div></div>';
	} else if ($type == 'fa' && $icon !='') {
	$out .= '<div class="round type-icon'.$stylex.' fa-theme-icon hover"><div class="icon-x icon-fa">'.$before_a.'<span class="fa fa-'.$icon.$styleclass.'"></span>'.$after_a.'</div></div>';
	} else {
	$out .= '<div class="round type-text'.$stylex.'"><div class="icon-x">'.$before_a.'<span class="title">'.$title.'</span>'.$after_a.'</div></div>';
	}
	$out .= '<div class="box-content">';
	if ($type == 'icon' && $title != '')
	$out .= '<div class="title-text">'.$before_a.'<h3 class="title">'.$title.'</h3>'.$after_a.'</div>';
	$out .= do_shortcode(clean($content));
	$out .= '</div>';
			
	$out .= '</div></div>';
	if ($firstlast == 'last') {
	$out .= '<div class="clr icon-box-clr">&nbsp;</div>';
	}
    return $out;
}
## iconline / icon-box @since 1.5 @version 1.1 @update 091515 @by iO
function nio_iconline($atts, $content = null) {
    extract(shortcode_atts(array(
		'name' => '',
		'size' => 'normal',
		'style' => 'ui',
		'fa' => '',
		'heading' => ''
    ), $atts));
	$out = $after_a = $before_a = '';
	
	$nameclass = cssclass($name, 'ic');
	$styleclass = cssclass($style, 'si');
	
	$faclass = cssclass($fa, 'fa');
	if ($fa) {
		$faclass .= ' fa';
	} else {
		$faclass .= ' icon';
	}
	if ($heading)
		$out .= '<'.$heading.' class="ntitle size-'.$size.'">';
		
    $out .= '<span class="nicon'.$nameclass.' size-'.$size.'"><i class="ic'.$styleclass.$faclass.'"></i></span>';
	
	if ($heading)
		$out .= '<span class="text">'.do_shortcode(clean($content)).'</span></'.$heading.'>';
		
    return $out;
}
## step @since 1.2 @version 1.0
function nio_step($atts, $content = null) {
    extract(shortcode_atts(array(
		'arrow' => 'next',
		'animate' => '',
		'duration' => '',
		'delay' => ''
    ), $atts));
	$aniclass = '';
	if ($animate) {
		$aniclass = ' animated';
		$animate = ' data-animate="'.$animate.'"';
		if ($duration !='') {
			$duration = ' data-duration="'.$duration.'"';
		} else {
			$duration = ' data-duration="1"';
		}
		if ($delay)
			$delay = ' data-delay="'.$delay.'"';
	}
    $out  = '';
	$out .= '<div class="istep istep-'.$arrow.$aniclass.'"'.$animate.$duration.$delay.'><span>&nbsp;</span></div>';
    return $out;
}
## title @since 1.6 @version 1.2 @update 011216 @by iO
function nio_title($atts, $content = null) {
    extract(shortcode_atts(array(
        'heading' => 'h2',
		'wrap' => '0',
		'name' => '',
		'ui' => '',
		'id' => ''
    ), $atts));
	if ($id) $id = ' id="'.$id.'"';
	$nameclass = cssclass($name, 'heading');
	$nameclass .= cssclass($ui, 'heading');
	
	if ($wrap == 'yes' || $wrap == '1') {
    	$out = '<div class="heading-wrap'.$nameclass.'"><div class="main"><'.$heading.$id.' class="heading heading-block"><span>'.do_shortcode($content).'</span></'.$heading.'></div></div>';
	} else {
    	$out = '<'.$heading.$id.' class="heading heading-block'.$nameclass.'"><span>'.do_shortcode($content).'</span></'.$heading.'>';
	}
    return $out;
}
## ephoto @since 1.1 @version 1.1 @update 091515 @by iO
function nio_ephoto($atts, $content = null) {
    extract(shortcode_atts(array(
        'name' => '',
		'title' => ''
    ), $atts));
	$nameclass = cssclass($name, 'ep');
	
    $out = '<div class="ephoto'.$nameclass.'"><div class="photo-inner">';
	$out .= '<div class="photo-block">'.do_shortcode(clean($content)).'</div>';
	
	if($title)
	$out .= '<div class="photo-caption">'.$title.'</div>';
		
	$out .= '</div></div>';
    return $out;
}
## econtent @since 1.1 @version 1.2 @update 122015 @by iO
function nio_econtent($atts, $content = null) {
    extract(shortcode_atts(array(
        'name' => '',
		'title' => '',
		'subtitle' => '',
		'maxwidth' => '',
        'ui' => '',
		'top' => '',
		'bottom' => '',
		'on' => '',
		'off' => ''
    ), $atts));
	$styles = '';
	$nameclass = cssclass($name, 'ec');
	$nameclass .= cssclass($ui, 'ec');
	
	if ($title || $subtitle) $nameclass .= cssclass('title', 'has');
	if ($on) $nameclass .= cssclass($on, 'on');
	if ($off) $nameclass .= cssclass($off, 'off');
	if ($top || $bottom || $maxwidth) {
		$styles .= ' style="';
		if ($top) $styles .= 'padding-top:'.$top.';';
		if ($bottom) $styles .= 'padding-bottom:'.$bottom.';';
		if ($maxwidth) $styles .= 'max-width:'.$maxwidth.';margin:0 auto;';
		$styles .= '"';		
	}
	
    $out = '<div class="econtent'.$nameclass.'"'.$styles.'><div class="content-inner">';
	if($title)
	$out .= '<div class="title"><h4><span>'.$title.' </span>'.$subtitle.'</h4></div>';
		
	$out .= '<div class="content">'.do_shortcode(clean($content)).'</div>';
	$out .= '</div></div>';
    return $out;
}
## slider @since 1.5 @version 1.0
function nio_slider($atts, $content = null) {
    extract(shortcode_atts(array(
        'name' => '',
		'group' => '',
		'desc' => '0',
		'title' => '0',
		'button' => '0',
		'delay' => '0',
		'effect' => 'fade',
		'button' => '0',
		'animation' => '0',
		'autoplay' => '6000',
		'maxheight' => '0',
		'type' => 'boxed',
		'navi' => '0',
		'dots' => '0',
		'on' => '',
		'off' => ''
    ), $atts));
	$out = '';
	$nameclass = cssclass($name, 'islider');
	if ($on) $nameclass .= cssclass($on, 'on');
	if ($off) $nameclass .= cssclass($off, 'off');
	if($maxheight =='' || $maxheight =='0' || $maxheight =='-1') $maxheight = '';
	else $maxheight = ' style="max-height:'.$maxheight.'px"';
	if ($group !='') $gpn = 'i'.$group; else $gpn = 'eflex'; 
		
	if ($type == 'boxed')
		$out .= '<div id="slider-'.$gpn.'" class="isliderx islider '.$type.'-slider '.$gpn.'-x'.$nameclass.'">';
	else if ($type == 'fullwidth'|| $type == 'fullwidex')
		$out .= '<div id="slider-'.$gpn.'" class="section isliderx islider '.$type.'-slider '.$gpn.'-x"><div class="banner-slider">';
	else
		$out .= '<div id="slider-'.$gpn.'" class="section isliderx islider '.$type.'-slider '.$gpn.'-x"><div class="main"><div class="banner-slider">';
	$out .= '<div class="flexslider eslider-'.$gpn.'"'.$maxheight.'>';
	$out .= '<ul id="'.$gpn.'" class="slides">';
		$i = 0;
		if ($group == "") $query = 'post_type=slides&posts_per_page=-1&post_status=publish&order=ASC&orderby=menu_order';
		else $query = 'post_type=slides&groups='.$group.'&posts_per_page=-1&post_status=publish&order=ASC&orderby=menu_order';
	
		// loop start
		query_posts($query);
		while ( have_posts() ) : the_post(); $i++;
		$before_a = $before_al = $after_a = $after_al = $target_a = $target_al = '' ;
		$link_slide		= meta_options('link_slide') ? meta_options('link_slide') : '';
		$target_slide	= meta_options('link_target') ? meta_options('link_target') : '';
		$link_btn 		= meta_options('btn_link') ? meta_options('btn_link') : '';
		$target_btn 	= meta_options('btn_target') ? meta_options('btn_target') : '';
		$btn_text 		= meta_options('btn_text') ? meta_options('btn_text') : '';
		if ($btn_text == '')  { $btn_text = 'Read More'; }
		if ($target_slide == 'new_page') { $target_a = ' target="_blank"'; }
		if ($target_btn == 'new_page') { $target_al = ' target="_blank"'; }
		if ($link_slide !='') {
			$before_a = '<a href="'.$link_slide.'"'.$target_a.'>';
			$after_a = '</a>';
		} 
		if ($link_btn !='') {
			$before_al = '<a href="'.$link_btn.'"'.$target_al.' class="button btn-action">';
			$after_al = '</a>';
		} 
		$scaption 	= ' caption-'.meta_options('slide_caption');
		$salign 	= ' align-'.meta_options('slide_align');
		$sposition 	= ' pos-'.meta_options('slide_position');
		$scolor 	= ' color-'.meta_options('slide_color');
		$bgcolor 	= ' bgcolor-'.meta_options('slide_bgcolor');
		$sclass 	= ' '.meta_options('slide_class');
			
		$out .= '<li class="slide slide'.$i.'">';
		if ($type != 'fullwidth' && $type != 'fullwidex')
			$out .= '<div class="thumbs">'.$before_a.'<img src="' .thumb_url_src($post->ID). '" alt="" />'.$after_a.'</div>'; 
		if($title_show == 'on' || $desc_show == 'on') {
			if ($type == 'fullwidth' || $type == 'fullwidex') { $out .= '<div class="main">'; }
			$t_count = strlen(get_the_title($post->ID));
			$c_count = strlen(get_the_content($post->ID));
			if (($title_show == 'on' && $t_count != 0) || ($desc_show == 'on' && $c_count != 0) || ($link_btn !='' && $btn_show == 'on')) {
				$out .= '<div class="overlay animate caption'.$scolor.$bgcolor.$salign.$sposition.$sclass.$scaption.'">';
			}
			if($title_show == 'on' && $t_count != 0) { $out .= '<div class="title animate"><h3>'; the_title(); $out .= '</h3></div>'; }				
			if($desc_show == 'on' && $c_count != 0) { $out .= '<div class="content animate">'; the_content(); $out .= '</div>'; } 
			if($btn_show == 'on' && $link_btn !='') { $out .= '<div class="call-action animate">'.$before_al.$btn_text.$after_al.'</div>'; } 
			if (($title_show == 'on' && $t_count != 0) || ($desc_show == 'on' && $c_count != 0) || ($btn_link !='' && $btn_show == 'on')) {
				$out .= '</div>';
			}
			if ($type == 'fullwidth'|| $type == 'fullwidex') { $out .= '</div>'; }
		}
		if ($type == 'fullwidth' || $type == 'fullwidex')
			$out .= '<div class="thumbs">'.$before_a.'<img src="' .thumb_url_src($post->ID). '" alt="" />'.$after_a.'</div>'; 
		$out .= '</li>';
		endwhile; wp_reset_query();
		// end loop
        $out .= '</ul>';
        $out .= '</div>';
		$out .= '<script type="text/javascript"> jQuery(document).ready(function($) {';
			// animation
			if ($animation == 'on') {
			$out .= "function ani() { ".
				 "$('.eslider-".$gpn." li .title, .eslider-".$gpn." li .content, ".
				 ".eslider-".$gpn." li .call-action').removeClass('fadeInRight').css('visibility', 'hidden');".
				 "$('.eslider-".$gpn." li.flex-active-slide .title, .eslider-".$gpn." li.flex-active-slide .content, ".
				 ".eslider-".$gpn." li.flex-active-slide .call-action').addClass('fadeInRight').css('visibility', 'visible');".
				 "$('.eslider-".$gpn." li.flex-active-slide .content').css({'-webkit-animation-delay': '.4s', ".
				 "'-moz-animation-delay': '.4s', '-o-animation-delay': '.4s', '-ms-animation-delay': '.4s','animation-delay': '.4s'});".
				 "$('.eslider-".$gpn." li.flex-active-slide .call-action').css({'-webkit-animation-delay': '.6s', ".
				 "'-moz-animation-delay': '.6s', '-o-animation-delay': '.6s', '-ms-animation-delay': '.6s','animation-delay': '.6s'});".
				 "};".
				 "ani();";
			}
			// centering 
			$out .= "function sCN() {".
				" var sG = $('.eslider-".$gpn."'), sC = $('.eslider-".$gpn." li:first-child .caption');".
				" var sC2 = $('.eslider-".$gpn." .flex-active-slide').next().find('.caption');".
				" var sGH = sG.height(), sCH = sC.height(), sC2H = sC2.height(), MT = ((sGH-sCH-100)/2), MT2 = ((sGH-sC2H-100)/2);".
				" if (sCH < sGH) { sC.stop().animate({marginTop: MT}, {easing: '', duration:500});".
				" } else { sC.stop().animate({marginTop:20 }, {easing: '', duration:500}); }".
				" if (sC2H < sGH) { sC2.stop().animate({marginTop: MT2}, {easing: '', duration:500});".
				" } else { sC2.stop().animate({marginTop:20 }, {easing: '', duration:500}); }".
			" };".
			" sCN();".
			" $(window).resize(function(){ sCN(); });";
			
			$out .= " $('.eslider-".$gpn."').flexslider({";
			if ($navi == '0') $out .= ' directionNav: false,'; else $out .= ' directionNav: true,';
			if ($dots == '0') $out .= ' controlNav: false,'; else $out .= ' controlNav: true,';
			if ($autoplay == '0') $out .= ' slideshow: false,'; else $out .= ' slideshow: true,';
			if ($autoplay !='') $out .= ' slideshowSpeed: '.$autoplay.','; else $out .= ' slideshowSpeed: 6000,';			
			if ($delay  != '' || $delay  != '0') $out .= ' initDelay: '.$delay.','; else $out .= ' initDelay: 0,';
			$out .= ' animation: "'.$effect.'",'.' easing: "swing",'.' direction: "horizontal",'.' animationSpeed: 700,'.' pauseOnAction: true,'.
					' pauseOnHover: false,'.' useCSS: false,'.' touch: true,'.' manualControls: "",'.' mousewheel: false,'.' start: function () { sCN();';
			if ($animation == 'on') $out .= 'ani();';
			$out .= '},';
			$out .= ' after: function(){ sCN();';
			if ($animation == 'on') $out .= 'ani();';
			$out .= ' }, }); });</script>';
			
		if ($type == 'boxed')
			$out .= '</div>';
		else if ($type == 'fullwidth' || $type == 'fullwidex')
			$out .= '</div></div>';
		else 
			$out .= '</div></div></div>';
	return $out;
}
## logolist @since 1.6 @version 1.0
function nio_logolist($atts, $content = null) {
    extract(shortcode_atts(array(
		'id' => '',
        'name' => '',
		'category' => '',
		'order' => 'ASC',
		'orderby' => 'menu_order date',
 		'perpage' => '-1',
		'style' => 'div',
		'thumb' => 'full',
		'title' => '0',
		'link' => '1',
		'carousel' => '1',
		'center' => 'false',
		'margin' => '0',
		'items' => '5',
		'dots' => 'false',
		'nav' => 'true',
		'autoplay' => 'false',
		'timeout' => '5000',
   ), $atts));
	$out = '';
	$jq	= ( $category != "" ) ? 'cat-'.$category : 'logo-lists';
	$ic1 = ( $items >='5' )	? round(($items/2+1), 0)	: $items;
	$ic2 = ( $ic1 >='4' )	? round(($ic1/2+1), 0) 		: $ic1;
	$ic3 = ( $ic2 >='3' )	? round(($ic2/2+1), 0) 		: $ic2;
	
	if ($id !='')	$ids = $id;
	else			$ids = ( $category != "" ) ? ' id="lc-'.$category.'"' : '';
	$nameclass = cssclass($name, 'lc');
	if ($carousel =='1' || $carousel =='yes')	$carousel = true;
	if ($carousel)	$nameclass .= ' logox-carousel';
	
	$out .= '<div'.$ids.' class="sc-logos logox logox-wrap'.$nameclass.'">';
		$out .= get_logos ($category, $order, $orderby, $perpage, $style, $thumb, $title, $link);
		if ($carousel)
		$out .= "<script type='text/javascript'> jQuery(document).ready(function($) { $('.".str_replace(" ", "",$jq)."').owlCarousel({ ".
				"center: ".$center.", margin: ".$margin.", items: ".$items.", autoWidth: false, loop:true, ".
				"autoplay: ".$autoplay.", autoplayTimeout: ".$timeout.", dots: ".$dots.", nav: ".$nav.", ".
				"responsive:{0:{ items: 1 }, 576:{ items: 2 }, 767:{ items: ".$ic2." }, 1024:{ items: ".$ic1." }, 1220:{ items: ".$items." }} }); ".
				"}); </script>";
	$out .= '<div class="clr"></div></div>';
	return $out;
}
## teamlist @since 1.6 @version 1.1
function nio_teamlist ($atts, $content = null) {
    extract(shortcode_atts(array(
		'id' => '',
		'ui' => '',
        'name' => '',
		'dept' => '',
		'order' => 'ASC',
		'orderby' => 'menu_order date',
 		'show' => '-1',
		'style' => 'div',
		'evenodd' => 'on',
		'cols' => '4',
		'thumb' => 'team-thumbs',
		'display' => 'over',
		'title' => '1',
		'desc' => '0',
		'social' => '1',
		'link' => '1',
		'linkalt' => '',
		'view' => 'col4',
		'items' => '5',
		'navi' => '1',
		'dots' => '0',
		'autoplay' => '0'
   ), $atts));
	$out = '';
	
	$uix = ($display!='') ? $display : 'basic';
	$id  = ($id!='') ? $id : 'a'.rand(10, 99).'z';
	if($dept != '') $ids = ' id="ltp-'.$dept.'"';
	else			$ids = ' id="ql-'.$id.'"';
	$nameclass = cssclass($name, 'lt');
	$nameclass .= cssclass($ui, 'lt');
	// For Slider	
	if ($view=='slide') $name = ($name !='') ? $name : $id;
	$sitem		= ($items!='') ? $items : 1;
	$sauto		= ($autoplay!='') ? $autoplay : 5000;
	$sdots		= ($dots=='0')	? 'false' : 'true';
	$snavi		= ($navi=='0') 	? 'false' : 'true';
	$sitemTBL 	= ($sitem>=5)	? 5 : $sitem;	 // 1280-1479
	$sitemTB 	= ($sitem>=4)	? 4 : $sitemTBL; // 1000-1279
	$sitemPD 	= ($sitemTB>=3)	? 3 : $sitemTB;	 // 600-999
	$sitemMB 	= ($sitemPD>=2)	? 2 : $sitemPD;	 // 379-599
	$out .= '<div'.$ids.' class="sc-teams teamx teamx-wrap'.$nameclass.'">';
		if (strlen($content) != 0) {
			$out .= '<div class="team-intro team-text">'.do_shortcode(clean($content)).'</div>';
		}
		$out .= get_teams ($dept, $order, $orderby, $show, $style, $view, $evenodd, $name, $uix, $cols, $thumb, $title, $desc, $social, $link, $linkalt);		
	if ($view=='slide') {
		$out .= '<script type="text/javascript"> jQuery(document).ready(function() { jQuery("#lts-'.$id.'").owlCarousel({';	
		$out .= 'margin:4, nav: '.$snavi.', dots: '.$sdots.', items: '.$sitem.', ';
		if ($sauto == 0) $out .= 'autoplay: false, '; else $out .= 'autoplay: true, autoplayTimeout: '.$sauto.', autoplaySpeed: 600, ';
		$out .= 'responsive:{ 0:{items:1}, 379:{items:'.$sitemMB.'}, 600:{items:'.$sitemPD.'}, 980:{items:'.$sitemTB.'}, 1280:{items:'.$sitemTBL.'}, 1480:{items:'.$sitem.'} }, ';
		$out .= 'loop: true, smartSpeed: 700 }); });</script>';
	}
	$out .= '<div class="clr"></div></div>';
	return $out;
}
## quotelist @since 1.6 @version 1.1
function nio_quotelist ($atts, $content = null) {
    extract(shortcode_atts(array(
		'id' => '',
        'name' => '',
		'order' => 'ASC',
		'orderby' => 'menu_order date',
 		'perpage' => '-1',
		'style' => 'ul',
		'wrap' => '0',
		'ui' => '0',
		'cols' => '1',
		'thumb' => 'quote-thumbs',
		'maintitle' => 'false',
		'textlen' => '0',
		'link' => '0',
		'linkalt' => '',
		'view' => 'col4',
		'evenodd' => 'off',
		'items' => '1',
		'navi' => '0',
		'dots' => '0',
		'autoplay' => '0'
   ), $atts));
	$out = '';
	if ($id == '') $id = 'a'.rand(10, 99).'z';
	$ids = ( $id != '' ) ? ' id="ql-'.$id.'"' : '';
	$nameclass = cssclass($name, 'ql');
	if ($wrap==1) $nameclass .= ' wrap-insidex';
	if ($view == 'slide' && $textlen == '0') $textlen = 50;
	
	// For Slider	
	$sitem		= ($items!='') ? $items : 1;
	$sauto		= ($autoplay!='') ? $autoplay : 5000;
	$sdots		= ($dots=='0')	? 'false' : 'true';
	$snavi		= ($navi=='0') 	? 'false' : 'true';
	$sitemTB 	= ($sitem>=4)	? 4 : $sitem;	// 1000-1480
	$sitemPD 	= ($sitemTB>=3)	? 3 : $sitemTB;	// 768-999
	$sitemMB 	= ($sitemPD>=2)	? 2 : $sitemPD;	// 479-767
	$out .= '<div'.$ids.' class="sc-quotes quotex quotex-wrap'.$nameclass.'">';
	if (strlen($content) != 0) {
		$out .= '<div class="quote-intro quote-text">'.do_shortcode(clean($content)).'</div>';
	}
	$out .= get_quotes ($order, $orderby, $perpage, $style, $view, $id, $wrap, $ui, $cols, $thumb, $maintitle, $textlen, $link, $linkalt);
	if ($view == 'slide') {
		$out .= '<script type="text/javascript"> jQuery(document).ready(function() { jQuery("#lqs-'.$id.'").owlCarousel({';	
		$out .= 'nav: '.$snavi.', dots: '.$sdots.', items: '.$sitem.', ';
		if ($sauto == 0) $out .= 'autoplay: false, '; else $out .= 'autoplay: true, autoplayTimeout: '.$sauto.', autoplaySpeed: 600, ';
		$out .= 'responsive:{ 0:{items:1}, 560:{items:'.$sitemMB.'}, 989:{items:'.$sitemPD.'}, 1279:{items:'.$sitemTB.'}, 1480:{items:'.$sitem.'} }, ';
		$out .= 'loop: true, smartSpeed: 700 }); });</script>';
	}
	$out .= '<div class="clr"></div></div>';
	return $out;
}
## tabs @since 1.1 @version 1.0
function nio_tabs($atts, $content = null){
	extract(shortcode_atts(array(
		'titles' => '',
		'style' => 'default',
		'heading' => ''
	), $atts));	
	$all_title = explode(',',$titles);
	if ($style == 'block') {
		$html ='<div class="itabs itabs-'.$style.'">';
		if ($heading) $html .= '<h3 class="tab-heading">'.$heading.'</h3>';
		$html .= '<ul class="tabs-nav tabs-nav-icon">';	
		foreach($all_title as $title){
			$html.= '<li class="'.str_replace(' ', '', strtolower($title)).'"><a href="#"><i class="round"><i class="icon"></i></i>'.$title.'</a></li>';
		}
		$html.='</ul><div class="tabs-container">'.do_shortcode(clean($content)).'</div></div><div class="clr">&nbsp;</div>';			
	} else {
		$html ='<div class="itabs itabs-'.$style.'">';
		if ($heading) $html .= '<h3 class="tab-heading">'.$heading.'</h3>';
		$html .= '<ul class="tabs-nav">';	
		foreach($all_title as $title){
			$html.= '<li><a href="#">'.$title.'</a></li>';
		}
		$html.='</ul><div class="tabs-container">'.do_shortcode(clean($content)).'</div></div><div class="clr">&nbsp;</div>';	
	}
	return $html;
}
## tab / tab-pane @since 1.1 @version 1.0
function nio_tab_pane($atts, $content = null) {		
	extract(shortcode_atts(array(
		'style' => 'default',
	), $atts));
	if ($style == 'block') {
		return '<div class="tab-content tab-pane"><div class="main">'.do_shortcode(clean($content)).'</div></div>';
	} else {
		return '<div class="tab-content tab-pane">'.do_shortcode(clean($content)).'</div>';
	}
}
## callout @since 1.1 @version 1.0 @update 091515 @by iO
function nio_callout($atts, $content = null) {
    extract(shortcode_atts(array(
        'name' => ''
    ), $atts));
    $out = '<div class="calout-box'. cssclass($name, 'cobox').'">'.do_shortcode('<i class="icon"></i>'.clean($content)).'</div>';
    return $out;
}
## download @since 1.1 @version 1.0
function nio_download($atts, $content = null) {
    extract(shortcode_atts(array(
        'link' 	=> '#',
		'title' => 'Download File',
		'icon' 	=> 'pdf',
		'size' 	=> 'small',
		'inline' => 'no'
    ), $atts));
	
	$out = '';
	if ($size == 'large') {
	$out .= '<div class="download-large">';
	}
	$out .= '<a class="download-button icon-'.$icon.' inline-'.$inline.' '.$size.'-icon" href="'.$link.'"';
    if($link != '#') {
        $out .= ' target="_blank"';
    }
    $out .= '>';
	if ($size != 'large') {
	$out .= '<span class="dl-title">'. $title .'</span>'; 
	}
    $out .= '</a>';
	if ($size == 'large') {
	$out .= '<span class="dl-title">'. $title .'</span>';
	$out .= '</div>'; 
	}
    if($inline == 'no')
	$out .= '<br />';
    return $out;
}
## button @since 1.1 @version 1.1 @update 091515 @by iO
function nio_button($atts, $content = null) {
    extract(shortcode_atts(array(
        'name' => '',
        'ui' => '',
        'type' => 'normal',
        'link' => '#',
        'target' => '',
        'bgcolor' => '',
        'textcolor' => '',
        'lightbox' => '',
        'tooltip' => '',
		'on' => '',
		'off' => ''
    ), $atts));
    
    $out = '';
	if ($name) $name .= cssclass($name, 'link');
	if ($ui) $name .= cssclass($ui, 'btn');
	if ($on) $name .= cssclass($on, 'on');
	if ($off) $name .= cssclass($off, 'off');
    $out .= '<a href="' . $link . '"';
	if ($type == 'link') {
		$out .= ' class="link-text';
	} else {
		$out .= ' class="button' . cssclass($type, 'btn') . '';
	}
    
    if ($tooltip != '') {
        $out .= ' btn-tooltip';
    }
    
    $out .= $name.'"';
    
    if ($bgcolor != '') {
        $out .= ' style="background-color:' . $bgcolor . ';';
        
        if ($textcolor != '') {
            $out .= ' color:' . $textcolor . ';"';
        }
    }
    
    if ($bgcolor == '' && $textcolor != '') {
        $out .= ' style="color:' . $textcolor . ';"';
    }
    
    if ($target == '_blank') {
        $out .= ' target="' . $target . '"';
    }
    
    if ($lightbox == 'true') {
        $out .= ' rel="lightbox"';
    } elseif($lightbox != '') {
        $out .= ' rel="'.$lightbox.'"';
	}
    
    if ($tooltip != '') {
        $out .= ' title="' . $tooltip . '"';
    }
    $out .= '>';
	
	$out .= '<span>';
    $out .= do_shortcode($content);
	$out .= '</span>';
	
    $out .= '</a>';
    
    return $out;
}
## cta @since 1.6 @version 1.0 @update 032516 @by iO
function nio_cta($atts, $content = null) {
    extract(shortcode_atts(array(
        'name' => 'block',
        'ui' => '',
        'section' => '0',
        'link' => '#',
		'text' => 'Learn More',
        'target' => '',
        'lightbox' => '',
		'on' => '',
		'off' => ''
    ), $atts));
    
    $out = $btn = '';
	if ($name) $nameclass = cssclass($name, 'cta');
	if ($section=='yes' || $section=='1') {	
		if ($ui) $nameclass .= cssclass($ui, 'section');
	} else {
		if ($ui) $nameclass .= cssclass($ui, 'cta');
	}
	if ($on) $nameclass .= cssclass($on, 'on');
	if ($off) $nameclass .= cssclass($off, 'off');
	// CTA Button
    $btn .= '<span class="cta-action"><a href="' . $link . '"';
	$btn .= ' class="button button-cta' . cssclass($ui, 'btn').'"';
    if ($target == '_blank')	$btn .= ' target="' . $target . '"';
    if ($lightbox == 'true')	$btn .= ' rel="lightbox"';
    elseif($lightbox != '')		$btn .= ' rel="'.$lightbox.'"';
    $btn .= '><span><i class="fa fa-phone"></i> '.$text.'</span></a></span>';
	if ($section == 'yes' || $section == '1') {
    	$out .= '<div class="section container-section section-cta call-action'.$nameclass.'"><div class="main">';
		$out .= '<div class="cta-wrap"><div class="cta-text">'.do_shortcode(clean($content)).'</div>'.$btn.'</div>';
		$out .= '</div></div>';
	} else {
    	$out .= '<div class="call-action'.$nameclass.'"><div class="cta-wrap"><div class="cta-text">'.do_shortcode(clean($content)).'</div>'.$btn.'</div></div>';
	}
	return $out;
}
## videobox @since 1.2 @version 1.0
function nio_videobox($atts, $content = null) {
    return '<div class="videobox">' . do_shortcode($content) . '</div>';
}
## quote @since 1.2 @version 1.1 @update 091615 @by iO
function nio_quote($atts, $content = null) {
	extract(shortcode_atts(array(
		'name' => '',
        'author' => '',
		'company' => ''
    ), $atts));
	$out = '';
	$nameclass = cssclass($name, 'aq');
    $out .= '<div class="quote'.$nameclass.'"><div class="block">' . do_shortcode(clean($content)) . '</div>';
	if ($author || $company) {
		$out .= '<div class="quote-by">';
			if ($author)
			$out .= '<h4 class="author">'.$author.'</h4>';
			if ($company)
			$out .= '<p class="company">'.$company.'</p>';
		$out .= '</div>';
	}
	$out .= '</div>';
	
	return $out;
}
## logos @since 1.1 @version 1.0
function nio_logos($atts, $content = null) {
	 extract(shortcode_atts(array(
	 	'cols' => 'fourth',
        'firstlast' => ''
    ), $atts));
	$out = '';
	if ($firstlast) $firstlast = ' '.$firstlast;
    $out = '<div class="cl-logo one-'.$cols.$firstlast.'"><div class="logo-block">' . do_shortcode(clean($content)) . '</div></div>';
    if ($firstlast == ' last')
	$out .= '<div class="clr"></div>';
	
	return $out;
}
## column / grid @since 1.6 @version 1.2 @update 122115 @by iO
function nio_column($atts, $content = null) {
	extract(shortcode_atts(array(
		'id' => '',
		'name' => '',
		'ui' => '',
		'on' => '',
		'off' => '',
		'size' => '', 			//1,2...11,12
		'grid' => '',			//1,2...11,12
	 	'cols' => 'col-full',	//one-half, one-third, one-fourth, two-third, three-fourth
        'firstlast' => ''		//first, last
    ), $atts));
	$out = $colclass = $gridclass = '';
	$nameclass = cssclass($name, 'ec');
	$nameclass .= cssclass($ui, 'ec');
	
	if ($on) $nameclass .= cssclass($on, 'on');
	if ($off) $nameclass .= cssclass($off, 'off');
	if ($firstlast) $nameclass .= ' '.$firstlast;
	
	if ($id) $id = ' id="'.$id.'"';
	
	if 		($size) $gridclass = ' grid'.$size;
	elseif 	($grid) $gridclass = ' grid'.$grid;
	if 		($cols) $colclass = ' '.$cols;
	
	if ($grid || $size)		
	$out .= '<div class="column'.$nameclass.$gridclass.'"'.$id.'><div class="content">' . do_shortcode(clean($content)) . '</div></div>';
	else
	$out .= '<div class="column'.$nameclass.$colclass.'"'.$id.'><div class="content">' . do_shortcode(clean($content)) . '</div></div>';
		
    if ($firstlast == 'last')
	$out .= '<div class="clr clr-col"></div>';
		
	return $out;
}
## offset @since 1.2 @version 1.0
function nio_offset($atts, $content = null) {
    extract(shortcode_atts(array(
        'grid' => '',
		'firstlast' => ''
    ), $atts));
	if ($firstlast) $firstlast = ' '.$firstlast;
	return '<div class="off-grid grid'.$grid.$firstlast.'">&nbsp;</div>';
}
## divider @since 1.2 @version 1.0
function nio_divider($atts, $content = null) {
	extract(shortcode_atts(array(
	 	'style' => 'default'
    ), $atts));
	$out = '';
    return '<div class="divider dv-'.$style.'"></div>';
}
## hr @since 1.1 @version 1.0
function nio_hr($atts, $content = null) {
	extract(shortcode_atts(array(
	 	'style' => 'default'
    ), $atts));
	$out = '';
    $out .= '<hr class="hr hr-'.$style.'">';
	return $out;
}
## gap @since 1.1 @version 1.0
function nio_gap($atts, $content = null) {
    extract(shortcode_atts(array(
        'size' => 'medium'
    ), $atts));
	return '<span class="gap gap-size-'.$size.'"></span>';
}
## line @since 1.6 @version 1.0
function nio_line($atts, $content = null) {
    extract(shortcode_atts(array(
        'size' => 'small',
		'align' => 'left',
		'color' => ''
    ), $atts));
	if ($color) $color = ' style="background-color:'.$color.';"';
	
	return '<div class="line line-'.$align.' line-size-'.$size.'"><i'.$color.'></i></div>';
}
## clear @since 1.1 @version 1.0
function nio_clear() {
    return '<div class="clr"></div>';
}
