<?php
/* @package ThemeNio
 * @copyright ThemeNio
 * @author ThemeNio Team
 * @version 1.6.1
 * @updated 150830#iO
 * @tags Main core file
 *
 * Description: ThemeNio is a wordpress framework which is lets you create a mordern website.
 * Website: http://www.themenio.com
 *
**/
// Function Support variable
$HeaderStyle = 'basic'; // 'advanced', 'none' (@default - basic)
// Include Custom Core Function
require_once (OF_INC . 'admin/framework.php');
require_once ('posttype.php');
require_once ('metabox.php');
require_once ('widget.php');
require_once ('shortcode.php');
// Menu/Nav Location Register
register_nav_menus( array(
	'primary' => 'Main Nav',
));
// Register Sidebar
register_sidebar( array(
	'id' => 'sidebar',
	'name' => __('Sidebar'),
	'description' => 'The sidebar widget area for inner pages',
	'before_widget' => '<div class="wgs wgs-side %2$s %1$s" id="%1$s"><div class="widget-content">',
	'after_widget' => '</div></div>',
	'before_title' => '<h3 class="wg-title"><span>',
	'after_title' => '</span></h3>',
) );
register_sidebar( array(
	'id' => 'sidebar-blog',
	'name' => __('Sidebar Blog'),
	'description' => 'The sidebar widget area for blog, archive and post pages',
	'before_widget' => '<div class="wgs wgs-side wgs-side-blog %2$s %1$s" id="%1$s"><div class="widget-content">',
	'after_widget' => '</div></div>',
	'before_title' => '<h3 class="wg-title"><span>',
	'after_title' => '</span></h3>',
) );
// Remove Some Info (from <head> tag)
if(!function_exists('nio_remove_headlink')) {
	function nio_remove_headlink() {
		remove_action('wp_head', 'rsd_link');
		remove_action('wp_head', 'wlwmanifest_link');
	}
	add_action('init', 'nio_remove_headlink');
	remove_action('wp_head', 'wp_generator');
}
// Script and StyleSheet Enqueue & Shortable for admin
if (is_admin()) {
	if(!function_exists('nio_media_upload_scripts')) {
		function nio_media_upload_scripts() {
			global $post;
			$out =	'<script type="text/javascript" id="nio-media-upload">'.
					'function addImage(_is, _h, _w) { '."\n".
					'window.send_to_editor_default = window.send_to_editor;'.
					'var _isP = jQuery(_is).parent().parent("div.field-row"), _isF = jQuery(_isP).find("input.image-url"); '."\n".
					'var _isFiD = jQuery(_isP).find("input.image-id"); '."\n".
					'tb_show(\'\', \'media-upload.php?post_id=' . $post->ID . '&amp;type=image&amp;TB_iframe=true\');'."\n".
					'window.send_to_editor = function(html) {'."\n".
						'jQuery("body").append(\'<div id="image-temp">\' + html + \'</div>\');'."\n".
						'var imgURL = jQuery("#image-temp").find("img").attr("src"); _isF.val(imgURL);'."\n".
						'var imgCLS = jQuery("#image-temp").find("img").attr("class");'."\n".
						'var imgID = parseInt(imgCLS.replace(/\D/g, ""), 10); _isFiD.val(imgID); '."\n".
						'jQuery(_is).next("a[name=remove]").show();'."\n".
						'jQuery(_isP).find("div.view-image").html(\'<img src="\' +imgURL+ \'" height="\' +_h+ \'" width="\' +_w+ \'" /></div>\');'."\n".
						'try{tb_remove();} catch(e){}; jQuery("#image-temp").remove();'."\n".
						'window.send_to_editor = window.send_to_editor_default;'.
					'};'."\n".
					'return false;'."\n".
					'} '."\n".
					'function removeImage (_is, _tx) {'."\n".
						'var _isP 	= jQuery(_is).parent().parent("div.field-row"), _isF = jQuery(_isP).find("input.image-url");'."\n".
						'var _isFiD = jQuery(_isP).find("input.image-id"); '."\n".
						'_isF.val(""); _isFiD.val(""); _isP.find("div.view-image").html("<span>" + _tx + "</span>");'."\n".
						'jQuery(_is).hide(); return false;'."\n".
					'}'."\n".
					'function addImgField(_is) {'."\n".
						'var _isR = jQuery(_is).parent().prev(".clone-row").html();'."\n".
						'var _isAp = jQuery(_is).parent().parent("div.inside-x").find("div.fields-wrap");'."\n".
						'jQuery(_isR).appendTo(_isAp);'."\n".
					'} '."\n".
					'function removeImgField(_is) {'."\n".
						'var _isP = jQuery(_is).parent().parent("div.field-row"); '."\n".
						'_isP.remove();'."\n".
					'}'.
					'</script>'."\n";
			$out .= '<style type="text/css">'.
					'.field-row .view-image {text-align:center;} '.
					'.view-image span { font-size:11px; line-height:13px; text-transform:uppercase; padding:15px 3px; display:block;}'.
					'.fields-wrap.gallery-view .field-row {float: left; width: 33.33%; min-height:105px; text-align:center; '.
					'padding:0 3px; -webkit-box-sizing:border-box; -moz-box-sizing:border-box; box-sizing:border-box;} '.
					'.fields-wrap.gallery-view .view-image {margin:-5px auto 0; width:70px; overflow:hidden; height:60px; position:relative;'.
					'border-radius:5px; border:1px solid #efefef;} .fields-wrap.gallery-view .view-image img { -webkit-transform:translateX(-50%); '.
					'-moz-transform:translateX(-50%); transform:translateX(-50%); position:absolute; top:0; left:50%;} '.
					'.fields-wrap.gallery-view .field-row a {text-decoration:none;} '.
					'.fields-wrap.gallery-view .field-row a.gal-delete {color:#900;}'.
					'.fields-wrap.gallery-view .field-row a.gal-delete:hover {color:#F00;}'.
					'.gallery-addmore {width:100%; float:left; text-align:center; margin-top:10px;}'.
					'</style>';
			echo $out;
		}
	}
	add_action( 'admin_head-post.php', 'nio_media_upload_scripts' );
	add_action( 'admin_head-post-new.php', 'nio_media_upload_scripts' );

}
if (!is_admin()) {
	if(!function_exists('nio_style_scripts')) {
		function nio_style_scripts() {
			//STYLESHEET
			wp_enqueue_style( 'stylesheet', get_template_directory_uri().'/style.css', true, '1.6.0');

	
			//SCRIPT
			//wp_deregister_script( 'jquery' );
			//wp_enqueue_script( 'jquery', get_template_directory_uri().'/js/core.jquery.js', true, '1.9.1');
			wp_enqueue_script( 'core-jquery-ui', get_template_directory_uri().'/js/core.jquery.ui.js', true, '1.10.4');
			wp_enqueue_script( 'core-plugin', get_template_directory_uri().'/js/core.plugins.js', true, '1.2.0');

		} 
		add_action('wp_enqueue_scripts', 'nio_style_scripts');
	}
}
// Widget Support shortcode by default
add_filter('widget_text', 'do_shortcode');
// Get post thumbnail url of full-size image
if(!function_exists('thumb_url')) {
	function thumb_url(){  
	  global $post;
	  $thumb_src = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), array( 2100,2100 ));
	  return isset($thumb_src[0]) ? $thumb_src[0] : '';
	}
}
if(!function_exists('thumb_url_src')) {
	function thumb_url_src($pid, $size=''){
		$image_id = get_post_thumbnail_id($pid);  
		$image_url = wp_get_attachment_image_src($image_id, $size);  
		return  isset($image_url[0]) ? $image_url[0] : '';  
	}
}
// Custom Text Excerpt
if(!function_exists('excerpt')) {
	function excerpt($excerpt_length=20, $contents=null) {
		global $post;
		if ($contents==null || $contents=='')
			$content = $post->post_content;
		else
			$content = $contents;
		
		$words = explode(' ', $content, $excerpt_length + 1);
		
		if(count($words) > $excerpt_length) :
			array_pop($words);
			array_push($words, '...');
			$content = implode(' ', $words);
		endif;
	  
		$content = strip_tags(strip_shortcodes($content));
		return $content;
	}
}
if(!function_exists('excerpt_title')) {
	function excerpt_title($length=99, $titles=null) {
		global $post;
		if ($titles==null || $titles=='')
			$title = $post->post_title;
		else
			$title = $titles;
		
		$words = explode(' ', $title, $length + 1);
		
		if(count($words) > $length) :
			array_pop($words);
			array_push($words, '...');
			$title = implode(' ', $words);
		endif;
		return $title;
	}
}
if(!function_exists('round_num')) {
	function round_num($num, $inc) {
		$return = 0;
		$new_num = $num/$inc; $num_flr = floor($new_num); 
		$num_frc = $new_num - $num_flr; $incx = 1/$inc;
		$num_ceil = (ceil($num * $incx) / $incx);
		
		if ($num_frc > 0.5) {
			$return = $num_ceil; 
		} elseif ($num_ceil > $inc) {
			$return = $num_ceil-$inc;
		} else {
			$return = $num_ceil; 
		}
		
		return $return;
	} 
}
## cssclass @since 1.6
function cssclass($str='', $key='', $after='', $center=1, $prefix=0) {
	$out = '';
	if ($after) $after = '-'.$after;
	$strs = explode(' ', $str);
	foreach ($strs as $strx) {
		if ($strx) {
			if ($strx == 'center' && ($center == true || $center == '' || $center == 1)) {
			$out .= ' '.$strx;
			} else {
				if ($prefix == true || $prefix == 1) {
					$out .= ' '.$strx.'-'.$key.$after;
				} else {
					$out .= ' '.$key.'-'.$strx.$after;
				}
			}
		}
	}
	return $out;
}
## autolink @since 1.6.2
function autolink($str, $attrs=array(), $format='http') {
	$gen_attrs = '';
	foreach ($attrs as $attr => $value) {
		$gen_attrs .= " {$attr}=\"{$value}\"";
	}
	$str = ' ' . $str;
	$str = preg_replace('`([^"=\'>])((http|https|ftp|ftps)://[^\s<]+[^\s<\.)])`i', '$1<a href="$2"'.$gen_attrs.'>$2</a>', $str );
	$str = substr($str, 1);
	return $str;
}
// nio_head @since 1.6
if(!function_exists('nio_head')) {
	function nio_head() {
		// Dynamic Styles
		if(function_exists('dynamic_style'))
		echo dynamic_style();
		
		// Custom CSS
		if (ao('custom_css') !== '') 
		echo '<style type="text/css">'.ao('custom_css').'</style>';
		
		// Custom Scripts
		echo ao('google_code');
	}
}
// Get Value from Theme Options
if(!function_exists('options')) {
	function options( $option ) {
		$options = get_option( 'theme_settings' );
		
		// return meta
		if ( isset( $options[$option] ) )
			return $options[$option];
		else
			return false;
	}
}
// shortform of options function key
if(function_exists('options') && !function_exists('ao')) {
	function ao($option) {
		$return = options($option);
		return $return;
	}
}
// Get Post Meta Options Value
if(!function_exists('meta_options')) {
	function meta_options( $option, $id=null) {
		global $post;
		if ($id !=null || $id !='')
		$meta = get_post_meta($id, $option, true);
		else
		$meta = get_post_meta($post->ID, $option, true);
		// return meta
		if ( isset( $meta ) )
			return $meta;
		else
			return false;
	}
}
// shortform of meta_options function key
if(function_exists('meta_options') && !function_exists('mo')) {
	function mo($option, $id=null) {
		$return = meta_options($option, $id);
		return $return;
	}
}
// Get Page Parent ID
if(!function_exists('get_page_parent')) {
	function get_page_parent() {
		global $post;
		if ($post->post_parent) {
			return $post->post_parent;
		} else {
			return false;
		}
	}
}
// Get Slug
if(!function_exists('get_slug')) {
	function get_slug($postID='') {
		global $post;
		$postID = ( $postID != '' ) ? $postID : $post->ID;
		$post_data = get_post($postID, ARRAY_A);
		$slug = $post_data['post_name'];
		return $slug;
	}
}
// Echo Slug
if(function_exists('get_slug') && !function_exists('the_slug')) {
	function the_slug($sufix='') {
		$get_slug = get_slug();
		if ($sufix !='') 
			$get_slug .= '-'.$sufix;	
	
		echo $get_slug;
	}
}
// Get Hide Pages (Only for one page template)
if(!function_exists('get_hide_pages')) {
	function get_hide_pages() {
		$array_of_pages = array();
		$get_all_pages = get_pages();
		if ( is_array ( $get_all_pages ) ) {
			foreach ( $get_all_pages as $onepage ) {
				if ( get_post_meta ( $onepage->ID , 'meta_page_show' , true ) == "on" ) {
					array_push ( $array_of_pages , $onepage->ID );
				}
			}
		}
		return $array_of_pages;
	}
}
// Archive Title
if(!function_exists('archive_title')) {
	function archive_title($default=null, $echo=true) {
		$title = '';
		if (is_search()) {
			$title = (get_bloginfo('language')=='fr-FR') ? 'Résultats de Recherche' : 'Search Results';
		} elseif (is_category()) {
			$title = single_cat_title('', false);
		} elseif( is_tag() ) {
			$title = (get_bloginfo('language')=='fr-FR') ? 'Articles Taggés &#8216;'.single_tag_title('', false).'&#8217;' : 'Posts Tagged &#8216;'.single_tag_title('', false).'&#8217;';
		} elseif (is_day()) {
			$title = (get_bloginfo('language')=='fr-FR') ? 'Archive pour '.get_the_time('F jS, Y') : 'Archive for &#8216;'.get_the_time('F jS, Y');
		} elseif (is_month()) {
			$title = (get_bloginfo('language')=='fr-FR') ? 'Archive pour '.get_the_time('F, Y') : 'Archive for '.get_the_time('F, Y');
		} elseif (is_year()) {
			$title = (get_bloginfo('language')=='fr-FR') ? 'Archive pour '.single_tag_title('', false) : 'Archive for '.get_the_time('Y'); 
		} elseif (is_author()) {
			$title = (get_bloginfo('language')=='fr-FR') ? 'Auteur Archive' : 'Author Archive';
		} elseif (isset($_GET['paged']) && !empty($_GET['paged'])) {
			$title = $default;
		}
		
		if ($echo == true) echo $title;
		else return $title;
	}
}
// Simple Menu Nav
if(!function_exists('simple_menu')) {
	function simple_menu( $location, $style = null, $sep = '|' ) {
		$select_menu = '';
		$locations = get_nav_menu_locations();
		if( isset( $locations[$location] ) ) {
			$menu = wp_get_nav_menu_object( $locations[$location] );
			if( is_object( $menu ) ) {
				$menu_items = wp_get_nav_menu_items( $menu->term_id );
				$menu_count = count($menu_items); $i=1;
				if( ! empty( $menu_items ) ) {
					if ($style == 'span') {
						$select_menu .= '<span class="quick-nav">';
						foreach( $menu_items as $key => $item ) {
							$select_menu .= '<a href="'.$item->url.'">'.strip_tags($item->title).'</a>';
							if ($i != $menu_count )
								$select_menu .= '<span class="sep"> '.$sep.' </span>';
							$i++;
						}
						$select_menu .= '</span>';
					} else {
						$select_menu .= '<ul class="quick-nav">';
						foreach( $menu_items as $key => $item ) {
							$select_menu .= '<li><a href="'.$item->url.'">'.strip_tags($item->title).'</a></li>';
						}
						$select_menu .= '</ul>';
					}
				}
			}
		}
		return $select_menu;
	}
}
// FB Share Thumbs (This part releted with admin option)
if(!function_exists('fb_share_thumb')) {
	function fb_share_thumb() {
		if (options('fb_share_image')!="") {
			$share  = '<meta content="284336748246943" property="fb:app_id" />'."\n";
			$share .= '<meta content="website" property="og:type" />'."\n";
			if ( is_home() || is_front_page() ) {
				$share .= '<meta content="'.options('fb_share_image').'" property="og:image" />'."\n";
			} elseif (thumb_url()) {
				$share .= '<meta content="'.thumb_url().'" property="og:image" />'."\n";
			} else {
				$share .= '<meta content="'.options('fb_share_image').'" property="og:image" />'."\n";
			}
			echo $share;
		}
	}
}
// Custom Pagination
if(!function_exists('paginate')) {
	function paginate() {
		global $wp_query, $wp_rewrite;
		$wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;
		$pagination = array(
			'base' 			=> @add_query_arg('page','%#%'),
			'format' 		=> '',
			'total'			=> $wp_query->max_num_pages,
			'current' 		=> $current,
			'show_all' 		=> true,
			'type' 			=> 'list', //plain
			'prev_next'		=> true,
			'prev_text'		=> '<',
			'next_text'		=> '>'
		);
		if( $wp_rewrite->using_permalinks() ) $pagination['base'] = user_trailingslashit( trailingslashit( remove_query_arg( 's', get_pagenum_link( 1 ) ) ) . 'page/%#%/', 'paged' );
		if( !empty($wp_query->query_vars['s']) ) $pagination['add_args'] = array( 's' => get_query_var( 's' ) );
		if ($pagination['total'] !=1) {
		echo '<div class="pagi">';
		//echo '<span class="page-total">(Page '.$pagination['current'].' of '.$pagination['total'].')</span>';
		echo paginate_links( $pagination );
		echo '</div>';
		}
	}
}
// hex2rgb color convert 
function hex2rgb($color=null) {
	if ($color==null) return false;
	
	$color = str_replace("#", "", $color);
	if(strlen($color) == 6) {
		$r = hexdec(substr($color,0,2));
		$g = hexdec(substr($color,2,2));
		$b = hexdec(substr($color,4,2));
	} else {
		$r = hexdec(substr($color,0,1).substr($color,0,1));
		$g = hexdec(substr($color,1,1).substr($color,1,1));
		$b = hexdec(substr($color,2,1).substr($color,2,1));
	}
	$rgb = array($r, $g, $b);
	return implode(", ", $rgb);
}
// CrossBrowsing/Browser Indentity 
if(!function_exists('browser')) {
	function browser($ua=null) {
		$ua = ($ua) ? strtolower($ua) : strtolower($_SERVER['HTTP_USER_AGENT']);		
		$ge = 'gecko';
		$we = 'webkit';
		$sa = 'safari';
		$ch = 'chrome';
		$ff	= 'firefox';
		$bw = array();
		// browser
		if( (!preg_match('/opera|webtv/i', $ua) && preg_match('/msie\s(\d+)/', $ua, $array)) || (preg_match('/trident\/(\d+)/', $ua) && preg_match('/rv\:(\d+)/', $ua, $array)) ) {
				$bw[] = 'ie ie' . $array[1];
		}	else if(strstr($ua, 'firefox/')) {
				$bw[] = (preg_match('/firefox\/(\d+)/i', $ua, $array)) ? $we . ' ' . $ff . ' ' . $ff . $array[1] . ' ff' . ' ff'.$array[1] : $we . ' ' . $ff;
		} else if(strstr($ua, 'gecko/')) {
				$bw[] = $ge;
		} else if(preg_match('/opera(\s|\/)(\d+)/', $ua, $array)) {
				$bw[] = 'opera opera' . $array[2];
		} else if(strstr($ua, 'konqueror')) {
				$bw[] = 'konqueror';
		} else if(strstr($ua, 'chrome')) {
				$bw[] = (preg_match('/chrome\/(\d+)/i', $ua, $array)) ? $we . ' ' . $ch . ' ' . $ch . $array[1] : $we . ' ' . $ch;
		} else if(strstr($ua, 'iron')) {
				$bw[] = $we . ' ' . $sa . ' iron';
		} else if(strstr($ua, 'applewebkit/')) {
				$bw[] = (preg_match('/version\/(\d+)/i', $ua, $array)) ? $we . ' ' . $sa . ' ' . $sa . $array[1] : $we . ' ' . $sa;
		} else if(strstr($ua, 'mozilla/')) {
				$bw[] = $ge;
		}
		// platform				
		if(strstr($ua, 'j2me')) {
				$bw[] = 'mobile';
		} else if(strstr($ua, 'iphone')) {
				$bw[] = 'iphone';		
		} else if(strstr($ua, 'ipod')) {
				$bw[] = 'ipod';		
		} else if(strstr($ua, 'ipad')) {
				$bw[] = 'ipad';		
		} else if(strstr($ua, 'mac')) {
				$bw[] = 'mac';		
		} else if(strstr($ua, 'darwin')) {
				$bw[] = 'mac';		
		} else if(strstr($ua, 'webtv')) {
				$bw[] = 'webtv';		
		} else if(strstr($ua, 'win')) {
				$bw[] = 'win';		
		} else if(strstr($ua, 'freebsd')) {
				$bw[] = 'freebsd';		
		} else if(strstr($ua, 'x11') || strstr($ua, 'linux')) {
				$bw[] = 'linux';		
		}
		return join(' ', $bw);
	}
}
// get_logos Functions @since 1.6 @version 1.0
if(!function_exists('get_logos')) {
	function get_logos ($category='', $order='ASC', $orderby='menu_order', $perpage='-1', $style='ul', $thumb='full', $title='0', $link='0') {
		$out = '';
		$class 	= ( $category != "" ) ? ' cat-'.$category : '';
		$div_ul	= ( $style != "div" ) ? 'ul' : 'div';
		$div_li	= ( $style != "div" ) ? 'li' : 'div';
	
		//Loop Start
		global $post;
		$qry_list = 'post_type=logo&post_status=publish&logo-cat='.$category.'&posts_per_page='.$perpage.'&order='.$order.'&orderby='.$orderby;
		query_posts($qry_list); $i = 0;
		if (have_posts()) : 
		$out .= '<'.$div_ul.' class="logo-lists'.$class.'">';
			while ( have_posts() ) : the_post(); $aBe = $aAf = ''; $i++;
			if (mo('logo-url') !='') {
				$aBe 	= '<a href="'.mo('logo-url').'" target="_blank">';
				$aAf 	= '</a>'; }
			if ($link == '0')	$aBe = $aAf = '';
				
			if ( has_post_thumbnail() ) {
				$out .= '<'.$div_li.' class="ilogo item lg'.$i.'"><div class="item-wrap">';
				$out .= '<div class="thumb logo-thumb">'.$aBe.get_the_post_thumbnail(get_the_ID(), $thumb).$aAf.'</div>'; 
				if ($title !='0' || $title != false)
				$out .= '<h4 class="title">'.get_the_title().'</h4>';
				$out .= '</div></'.$div_li.'>';
			}
			endwhile;
		$out .= '</'.$div_ul.'>';
		endif; wp_reset_query();
		//Loop End
		return $out;
	}
}
// get_teams Functions @since 1.6 @version 1.1 @update 160402
if(!function_exists('get_teams')) {
	function get_teams ($dept='',$order='ASC',$orderby='menu_order',$perpage='-1',$style='div',$view='list',$evenodd='off',$name=null,$uix='0',$cols='4',$thumb='team-thumbs',$title='1',$desc='0',$social='0',$link='0',$linkalt='') {
		$out = $colx = $gridx = $dep_qry = ''; $cols = (int)$cols;
		$view 	= ( $view != "" ) ? $view: 'list';
		$class 	= ( $dept != "" ) ? ' dept-'.$dept : '';
		$div_ul	= ( $style != "div" ) ? 'ul' : 'div';
		$div_li	= ( $style != "div" ) ? 'li' : 'div';
		$class_li = ( $uix != "" ) ? ' ui-'.$uix : '';
		$clr = '<div class="clr"></div>';
		
		$id = ($name !='') ? ' id="lts-'.$name.'"' : '';
		if ($name!='') { $class .= ' team-'.$name; }
		if ($view == 'slide' ) { $class .= ' team-slides'; }
		// Style Condition
		if ($view == "list") {
			$gridx = ' col-fluid list-item';
			$evenodd = 'off';
		} elseif ($view == "slide") {
			$gridx = ' item';
			$evenodd = 'off';
		} else  {
			if ($cols <= 1)	: $grid = 12; elseif ($cols >= 4) : $grid = 3; elseif ($cols == 2) : $grid = 6; 
			elseif ($cols == 3) : $grid = 4; else : $grid = 3; endif;
			$colx = ' col-x'.$cols;
			$gridx = ' grid'.$grid;
			$evenodd = 'on';
		}
		if ($view == 'col4') { $cols = 4; }
		if ($view == 'col3') { $cols = 3; }
		if ($view == 'col4' || $view == 'col3') {
			$div_ul = $div_li = 'div'; $evenodd = 'on';
		}
		//Loop Start
		global $post;
		if ($dept) $dep_qry = '&team-dept='.$dept;
		$qry_list = 'post_type=team&post_status=publish'.$dep_qry.'&posts_per_page='.$perpage.'&order='.$order.'&orderby='.$orderby;
		$qpcount = count(query_posts($qry_list)); $i = 0;
		if (have_posts()) : 
		$out .= '<'.$div_ul.' class="team-lists style-'.$view.$class.'"'.$id.'>';
			while ( have_posts() ) : the_post();  $i++;
			$entrys = $entrys_o = $link_icon = $teamlink = $aBe = $aBeB = $aAf = '';
			$f = $l = $break_clr = ''; $endlast = false;
			if ($cols>1 && $cols<5 && $evenodd=="on") {
				if ($i%$cols==1) $f = ' first'; 
				if ($i%$cols==0) { 
					$f = ' last';
					$break_clr = $clr;
					$endlast = true;
				}
			}
			// Link
			$link_url = ($linkalt !='') ? $linkalt : get_permalink($post->ID);
			if ($link != '0') {
				$link_icon = '<i class="icon-link fa fa-link"></i>';
				$aBe = '<a href="'.$link_url.'">'; $aAf = '</a>';
				$aBeB = '<a class="button btn-profile" href="'.$link_url.'">'; 
			}
			// Socials 
			$over_social = ($uix=='over-links') ? ' links-over' : ' links-plain';
			if ( mo('team-fb') || mo('team-tw') || mo('team-in') || mo('team-gp') || mo('team-email') ) {
				$teamlink .= '<div class="links'.$over_social.'">';
				if (mo('team-fb'))
					$teamlink .= '<a class="s-fb" href="'.mo('team-fb').'" target="Facebook" target="_blank"><i class="fa fa-facebook"></i></a>';
				if (mo('team-tw'))
					$teamlink .= '<a class="s-tw" href="'.mo('team-tw').'" target="Twitter" target="_blank"><i class="fa fa-twitter"></i></a>';		
				if (mo('team-in'))
					$teamlink .= '<a class="s-in" href="'.mo('team-in').'" target="Linkedin" target="_blank"><i class="fa fa-linkedin"></i></a>';
				if (mo('team-gp'))
					$teamlink .= '<a class="s-gp" href="'.mo('team-gp').'" target="Google+" target="_blank"><i class="fa fa-google-plus"></i></a>';
				if (mo('team-email'))
					$teamlink .= '<a class="s-email" href="mailto:'.mo('team-email').'" target="Email Us"><i class="fa fa-envelope"></i></a>';	
				$teamlink .= '</div>';
			}
			
			// Title/Position/Details
			$postion_title = (mo('team-title') !='') ? '<p class="position">'.mo('team-title').'</p>' : '';
			if ($title !='0' || $desc !='0') {
				$entrys .= '<div class="data-team">';
					if ($title !='0') 
					$entrys .= '<div class="info"><h4 class="name">'.$aBe.get_the_title($post->ID).$aAf.'</h4>'.$postion_title.'</div>';
					if ($desc !='0')
					$entrys .= '<div class="entry">'.wpautop(get_the_content($post->ID)).'</div>';
				$entrys .= '</div>';
				
				if ($uix == 'over' && $title !='0') {
					$entrys_o .= '<h4 class="name">'.get_the_title($post->ID).'</h4>'.$postion_title;
				}
			}
			$out .= '<'.$div_li.' class="iteam team-'.$i.$class_li.$colx.$gridx.$f.$l.'">';
				if ( has_post_thumbnail() ) {
					$out .= '<div class="thumbs thumbs-team">';
						if ($uix == 'over' && $entrys_o !='') {
							$out .= $aBe.get_the_post_thumbnail($post->ID, $thumb).'<span class="over"><span>'.$link_icon.$entrys_o.'</span></span>'.$aAf;
						} else {
							$out .= $aBe.get_the_post_thumbnail($post->ID, $thumb);
							if ($link != '0') $out .= '<span class="over">'.$link_icon.'</span>';
							$out .= $aAf;
							if ($uix == 'over-links' && $social != '0') $out .= $teamlink;
							
						}
					$out .= '</div>';
				}
				
				if ($uix != 'over') {
					$out .= $entrys;
				}
				if ( $uix != 'over' && $uix != 'over-links' && $social != '0')
					$out .= $teamlink;
			$out .= '</'.$div_li.'>'.$break_clr;
			if ($i==$qpcount && $endlast==false && $evenodd=="on") {
				$out .='<div class="clr"></div>';
			}
			endwhile;
		$out .= '</'.$div_ul.'>';
		endif; wp_reset_query();
		//Loop End
		return $out;
	}
}
// get_quotes Functions @since 1.6 @version 1.1
if(!function_exists('get_quotes')) {
	function get_quotes ($order='ASC', $orderby='menu_order', $perpage=-1, $style='div', $view='list', $name=null, $wrap=0, $ui=0, $cols=0, $thumb='quote-thumbs', $maintitle='hide', $textlen=0, $link=0, $linkalt='') {
		$out = $gridx = $colx = $class 	= $id = '';
		$div_ul	= ( $style != "div" ) ? 'ul' : 'div';
		$div_li	= ( $style != "div" ) ? 'li' : 'div';
		if ($ui==1) $class .= ' uix';
		if ($view == 'slide' ) $class .= ' quote-slides'; 
		if ($name!=null) { $class .= ' quote-'.$name;  $id = ' id="lqs-'.$name.'"'; }
		if ($cols <= 1) { $col = 1; } 
		elseif($cols >= 4) { $col = 4; } 
		else { $col = $cols; }
		if ($view == "list") {
			$gridx = ' col-fluid list-view';
		} elseif ($view == "slide") {
			$gridx = ' col-no item';
		} else  {
			if ( $ui == 1 ) {
				$colx = ' col'.$col;
				if ($cols <= 1) $colx = ' col-no';
				$gridx = ' col-fluid col-inline'; 
			} else {
				if ($cols <= 1)	: $grid = 12; elseif ($cols >= 4) : $grid = 3; elseif ($cols == 2) : $grid = 6; 
				elseif ($cols == 3) : $grid = 4; else : $grid = 3; endif;
				$colx = ' col-x'.$col;
				$gridx = ' grid'.$grid;
			}
		}
		//Loop Start
		global $post;
		$qry_list = 'post_type=quote&post_status=publish&posts_per_page='.$perpage.'&order='.$order.'&orderby='.$orderby;
		$qpcount = count(query_posts($qry_list)); $i = 0;
		if (have_posts()) : 
		$out .= '<'.$div_ul.' class="quote-lists'.$class.'"'.$id.'>';
			while ( have_posts() ) : the_post(); 
			$mtitles = $titles = $thumbnails = $authors = $quotes = $aBe = $aAf = $readmore = $ratings = ''; $i++;
			
			$f = $l = $break_clr = ''; $endlast = false;
			if ($view != 'slide' && $cols >=2 ) {
				if( (($i-1)%$cols) == 0 ) 	$f = ' first';
				if( ($i%$cols) == 0 ) {
					$l = ' last';
					$break_clr 	= '<div class="clr"></div>';
					$endlast = true;
				}
			}
			// main title 
			if ($maintitle == 'show') {
				$mtitles .= '<h2 class="quote-title">'.get_the_title().'</h2>'; 
			}
			// heading quote
			if (mo('quote-heading')) {
				$titles .= '<div class="quote-heading">'.wpautop(mo('quote-heading')).'</div>'; 
			}
			// thumbs quote
			if ( $thumb != false && has_post_thumbnail() ) {
				$thumbnails .= '<div class="quote-photo thumbs-quote">';
					$thumbnails .= get_the_post_thumbnail($post->ID, $thumb);
				$thumbnails .= '</div>';
			}
			// author quote
			if (mo('quote-author') || mo('quote-position') || mo('quote-company') || mo('quote-website')) {
				$authors .= '<div class="quote-author">';
				if (mo('quote-author'))
				$authors .= '<h4 class="name">'.mo('quote-author').'</h4>';
				if (mo('quote-position'))
				$authors .= '<p class="position">'.mo('quote-position').'</p>';
				if (mo('quote-company'))
				$authors .= '<p class="company">'.mo('quote-company').'</p>';
				if (mo('quote-website'))
				$authors .= '<p class="website">'.
						'<a href="'.mo('quote-website').'" target="_blank">'.str_replace('http://','',mo('quote-website')).'</a></p>';
				$authors .= '</div>';
			}
			
			// Rating
			if (mo('quote-ratings')) { 
				$ratings .= '<p class="ratings">';
				if (mo('quote-ratings') == '1') $ratings .= '<span class="fa fa-star"></span><span class="fa fa-star-o"></span><span class="fa fa-star-o"></span><span class="fa fa-star-o"></span><span class="fa fa-star-o"></span>';
				
				if (mo('quote-ratings') == '2') $ratings .= '<span class="fa fa-star"></span><span class="fa fa-star"></span><span class="fa fa-star-o"></span><span class="fa fa-star-o"></span><span class="fa fa-star-o"></span>';
				
				if (mo('quote-ratings') == '3') $ratings .= '<span class="fa fa-star"></span><span class="fa fa-star"></span><span class="fa fa-star"></span><span class="fa fa-star-o"></span><span class="fa fa-star-o"></span>';
				
				if (mo('quote-ratings') == '4') $ratings .= '<span class="fa fa-star"></span><span class="fa fa-star"></span><span class="fa fa-star"></span><span class="fa fa-star"></span><span class="fa fa-star-o"></span>';
				
				if (mo('quote-ratings') == '5') $ratings .= '<span class="fa fa-star"></span><span class="fa fa-star"></span><span class="fa fa-star"></span><span class="fa fa-star"></span><span class="fa fa-star"></span>';
				
				$ratings .= '</p>';
			}
			
			// links quote
			$url = ($linkalt!='') ? $linkalt : get_permalink($post->ID);
			$txt = ($linkalt!='') ? 'Read All Testimonial' : 'Read full testimonial'; 
			if ($link == '1' || $link == 1) {
				$aBe = '<a href="'.$url.'">'; $aAf = '</a>';
				$readmore .= '<div class="view-more">'.$aBe.$txt.$aAf.'</div>';
			}
			// text quote			
			if (strlen(get_the_content($post->ID)) != 0) {
				if ($textlen != '0' && $textlen != '-1' && $textlen != '') {
					$quotes .= '<div class="quote-content"><p>'.excerpt($textlen).'</p></div>'; 
				} else {
					$quotes .= '<div class="quote-content">'.apply_filters('the_content', get_the_content($post->ID)).'</div>'; 
				}
			}
			
			$out .= '<'.$div_li.' class="iquote quote-'.$i.$gridx.$colx.$f.$l.'">';
			$out .= '<div class="block">';
				if ($wrap == 1 && $ui == 1) {
					$out .= '<div class="container">';
				}
				if ($ui == 1) {
					$out .= '<div class="content"><div class="grid5 first">'.$titles.'</div>';
					$out .= '<div class="grid7 last">'.$thumbnails.$mtitles.$ratings.$quotes.$authors.$readmore.'</div><div class="clr"></div></div>';
				} else {
					$out .= $thumbnails.$mtitles.$titles.$ratings.$quotes.$authors.$readmore;
				}
				if ($wrap == 1 && $ui == 1) {
					$out .= '</div>';
				}
			$out .= '</div>';
			$out .= '</'.$div_li.'>';
			$out .= $break_clr;
			if ($i == $qpcount && $endlast == false && $view != 'slide' && $view != 'list') {
				$out .='<div class="clr"></div>';
			}
			endwhile;
		$out .= '</'.$div_ul.'>';
		endif; wp_reset_query();
		//Loop End
		return $out;
	}
}
// get_iposts Functions @since 1.6 @version 1.1
if(!function_exists('get_iposts')) {
	function get_iposts ($cats='', $order='DESC', $orderby='date', $count=4, $opt_sticky='off', $style='div', $evenodd='off', $view='list', $name=null, $ui=0, $cols=1, $thumb='thumbnail', $opt_title='on', $opt_desc='on', $opt_thumb='on', $opt_cat='off', $opt_date='off', $opt_more='on', $titlelen=12,$textlen=25, $linkalt=''){
	$out = $by_post = $cclass = $link = $clr = ''; $dvU = 'ul'; $dvL = 'li'; 
	$colx = ' col-x';  $gridx = ' grid'; $grids = ' col-no';
	$cols = ($cols !='')? (int)$cols : 4; if ($cols>=4) $cols = 4;
	if ($name!=null) { $class .= ' iposts-'.$name; }
	if ($cats	!= '') $cclass .= ' cat-'.$cats;
	
	// Excerpt count
	$titlelen 	= ($textlen !='')? (int)$textlen : 12;
	$textlen 	= ($textlen !='')? (int)$textlen : 25;
	$count		= ($count !='')? (int)$count : 4; 
	$countx 	= $count;
	// Style Condition
	if ($view == 'col4' || $cols>=4) { $cols = 4; }
	if ($view == 'col3' || $cols==3) { $cols = 3; }
	if ($view == 'col4' || $view == 'col3' || $style=='div') { $dvU = $dvL = 'div'; }
	if ($view == 'col4' || $view == 'col3') { $grids = $colx.$cols; $evenodd = 'on'; $clr = '<div class="clr"></div>'; } 
	if ($view == 'col3' ) $countx =  round_num ($count, 3);
	if ($view == 'col4' ) $countx =  round_num ($count, 4);
	
	// Grid condition
	if ($style== 'grid' && $cols>1 && $cols<5) { 
		$evenodd = 'on'; $clr = '<div class="clr"></div>'; $view = 'box'; $countx =  round_num ($count, $cols);
		if ($cols==2) { $grids = $gridx.'6'.$colx.$cols; } elseif ($cols==3) { $grids = $gridx.'4'.$colx.$cols; } 
		elseif ($cols==4) { $grids = $gridx.'3'.$colx.$cols; } else { $grids = ' col-no'; }
	}
	if ($opt_sticky == 'on') {
		$sticky = get_option('sticky_posts'); $by_post .= ' has-featured';
		$postArgs = array(
					'post_type' => 'post', 'post__in' => $sticky, 'order' =>$order, 'orderby' => $orderby, 
					'posts_per_page' => $countx, 'ignore_sticky_posts' => false );
	} else {
		if ($cats !='') $by_post .= ' no-featured';			
		$postArgs = array(
					'post_type' => 'post', 'category_name' => $cats, 'order' =>$order, 'orderby' => $orderby, 
					'posts_per_page' => $countx, 'ignore_sticky_posts' => true );
	}
	$recPost = new WP_Query( $postArgs );
	if ($recPost->have_posts()) : $v = 0;
		if ($opt_title == 'on'|| $opt_desc == 'on' || $opt_thumb == 'on') {
		$out .= '<'.$dvU.' class="irecent-posts style-'.$view.$cclass.$by_post.'">';
			while ($recPost->have_posts()) : $recPost->the_post(); $v++; $f = $l = $entrys = '';
			if ($cols>1 && $cols<5 && $evenodd == 'on') {
				if ($v%$cols== 1) $f = ' first'; 
				if ($v%$cols== 0) $f = ' last';
			}  
			if ( $linkalt !='' ) { $link = $linkalt; } 
			else { $link = get_permalink($recPost->ID); }
			$postcats = get_the_category($recPost->ID);
			
			if ($opt_title == 'on' || $opt_desc == 'on') {
				$entrys .= '<div class="entry">';
				if ($opt_cat == 'on') 
				$entrys .= '<div class="cats">'.$postcats[0]->cat_name.'</div>';
				if ($opt_title == 'on')
				$entrys .= '<h4 class="title"><a href="'.$link.'">'.excerpt_title($titlelen).'</a></h4>';
				if ($opt_date == 'on')
				$entrys .= '<div class="date">'.get_the_date().'</div>';
				if ($opt_desc == 'on')
				$entrys .= '<p>'.excerpt($textlen, $recPost->post_content).'</p>';
				if ($opt_more == 'on')
				$entrys .= '<p class="more"><a href="'.$link.'" class="link-more">Read More</a></p>';
				$entrys .= '</div>';
			}
				
			$out .= '<'.$dvL.' class="items item'.$v.$grids.$l.$f.'">';
			if ($opt_sticky == 'on') $out .= $entrys;
			if ( has_post_thumbnail() && $opt_thumb == 'on' ) {
				$out .= '<div class="thumbs"><a href="'.$link.'">';
				$out .= get_the_post_thumbnail($recPost->ID, $thumb);
				$out .= '<span class="over"><i class="icon-link fa fa-link"></i></span></a></div>'; 
			}	
			if ($opt_sticky != 'on') $out .= $entrys;
			
			$out .= '</'.$dvL.'>';
			endwhile;
		$out .= $clr.'</'.$dvU.'>'; 
		}
	endif; wp_reset_postdata();
	return $out;
	}
}