<?php
/* @package ThemeNio
 * @copyright ThemeNio
 * @version 1.6.2.1
 * @updated 150830#iO
 * @tags meta-boxes for wordpress
 *
 * !Important Note: All the custom-widget function initialize into theme-widget.php (which is found in inc folder)
 *
**/
 
## Custom Text Widget @since 1.1 @version 1.3
class custom_text extends WP_Widget {
    function __construct() {
        $widgets_opt = array('description'=>'Display arbitrary text or HTML in widget (v1.3)');
        parent::__construct(false,$name= "Theme - Custom Text", $widgets_opt);
    }
    function form($instance) {
        $title      = isset($instance['title']) ? esc_attr($instance['title']) : '';
        $contentx   = isset($instance['contentx']) ? esc_attr($instance['contentx']) : '';
        $ptag      = isset($instance['ptag']) ? esc_attr($instance['ptag']) : '';
        $cclass      = isset($instance['cclass']) ? esc_attr($instance['cclass']) : '';
        $minh      = isset($instance['minh']) ? esc_attr($instance['minh']) : '';
        $cols      = isset($instance['cols']) ? esc_attr($instance['cols']) : '';
        $nth      = isset($instance['nth']) ? esc_attr($instance['nth']) : '';
        $readmore      = isset($instance['readmore']) ? esc_attr($instance['readmore']) : '';
        $more_link      = isset($instance['more_link']) ? esc_attr($instance['more_link']) : '';
        $hideopt      = isset($instance['hideopt']) ? esc_attr($instance['hideopt']) : '';
    ?>
	<script type="text/javascript">
	jQuery(document).ready(function($){
		$("a.custom-text-more-option").click(function(){
			$(this).next('.custom-text-more').slideDown(400);
			$('#<?php echo $this->get_field_id('hideopt'); ?>').val('show');
			$(this).delay(400).hide();
			return false;
        });	
		$("a.custom-text-less-option").click(function(){
			$(this).parent('.custom-text-more').slideUp(400);
			$(this).parent().prev('a.custom-text-more-option').delay(500).show(0);
			$('#<?php echo $this->get_field_id('hideopt'); ?>').val('hide');
			return false;
        });	
		if($('#<?php echo $this->get_field_id('hideopt'); ?>').val() == 'show') {
			$('.custom-text-more').show();
			$('a.custom-text-more-option').hide(400);
		}
	});
    </script> 
    <p><label for="<?php echo $this->get_field_id('title'); ?>">Title:</label>
    <input id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" class="widefat" value="<?php echo $title;?>" /></p>
    <p><textarea style="height:150px;" id="<?php echo $this->get_field_id('contentx'); ?>" name="<?php echo $this->get_field_name('contentx'); ?>" class="widefat"><?php echo $contentx;?></textarea><br />
    <input class="checkbox" type="checkbox" <?php if ($ptag == "on") echo "checked";?> id="<?php echo $this->get_field_id('ptag'); ?>" name="<?php echo $this->get_field_name('ptag'); ?>" /><label for="<?php echo $this->get_field_id('ptag'); ?>"> Automatically add paragraphs</label></p>
    <input type="hidden" id="<?php echo $this->get_field_id('hideopt'); ?>" name="<?php echo $this->get_field_name('hideopt'); ?>" class="widefat" value="<?php echo $hideopt;?>" />
    <a href="#" class="custom-text-more-option">Show more options</a>
    <div class="custom-text-more" style="display:none;"> 
    <p><label for="<?php echo $this->get_field_id('cols'); ?>">Grid / Column:</label><br />
    <select name="<?php echo $this->get_field_name('cols'); ?>" id="<?php echo $this->get_field_id('cols'); ?>" class="widefat" style="width:115px;">
    	<option value=""<?php if ($cols == '') { echo ' selected="selected"'; } ?>>No Column</option>
    	<option value="one-half"<?php if ($cols == 'one-half') { echo ' selected="selected"'; } ?>>Col 1/2</option>
    	<option value="one-third"<?php if ($cols == 'one-third') { echo ' selected="selected"'; } ?>>Col 1/3</option>
    	<option value="two-third"<?php if ($cols == 'two-third') { echo ' selected="selected"'; } ?>>Col 2/3</option>
    	<option value="one-fourth"<?php if ($cols == 'one-fourth') { echo ' selected="selected"'; } ?>>Col 1/4</option>
    	<option value="three-fourth"<?php if ($cols == 'three-fourth') { echo ' selected="selected"'; } ?>>Col 3/4</option>
    	<option value="col-full"<?php if ($cols == 'col-full') { echo ' selected="selected"'; } ?>>Col Full</option>
    	<option value="grid1"<?php if ($cols == 'grid1') { echo ' selected="selected"'; } ?>>Grid 1</option>
    	<option value="grid2"<?php if ($cols == 'grid2') { echo ' selected="selected"'; } ?>>Grid 2</option>
    	<option value="grid3"<?php if ($cols == 'grid3') { echo ' selected="selected"'; } ?>>Grid 3</option>
    	<option value="grid4"<?php if ($cols == 'grid4') { echo ' selected="selected"'; } ?>>Grid 4</option>
    	<option value="grid5"<?php if ($cols == 'grid5') { echo ' selected="selected"'; } ?>>Grid 5</option>
    	<option value="grid6"<?php if ($cols == 'grid6') { echo ' selected="selected"'; } ?>>Grid 6</option>
    	<option value="grid7"<?php if ($cols == 'grid7') { echo ' selected="selected"'; } ?>>Grid 7</option>
    	<option value="grid8"<?php if ($cols == 'grid8') { echo ' selected="selected"'; } ?>>Grid 8</option>
    	<option value="grid9"<?php if ($cols == 'grid9') { echo ' selected="selected"'; } ?>>Grid 9</option>
        <option value="grid10"<?php if ($cols == 'grid10') { echo ' selected="selected"'; } ?>>Grid 10</option>
        <option value="grid11"<?php if ($cols == 'grid11') { echo ' selected="selected"'; } ?>>Grid 11</option>
    	<option value="grid12"<?php if ($cols == 'grid12') { echo ' selected="selected"'; } ?>>Grid 12</option>
    </select>&nbsp;&nbsp; 
    <input type="radio" <?php if ($nth=="none"||$nth=="") {echo "checked ";} ?>value="none" name="<?php echo $this->get_field_name('nth'); ?>" />
    <label for="<?php echo $this->get_field_id('nth'); ?>">Default</label>&nbsp; 
    <input type="radio" <?php if ($nth=="first") {echo "checked ";} ?>value="first" name="<?php echo $this->get_field_name('nth'); ?>" />
    <label for="<?php echo $this->get_field_id('nth'); ?>">First</label>&nbsp; 
    <input type="radio" <?php if ($nth=="last") {echo "checked ";} ?>value="last" name="<?php echo $this->get_field_name('nth'); ?>" />
    <label for="<?php echo $this->get_field_id('nth'); ?>">Last</label></p>
    <div style="width:100%; overflow:hidden">
    	<div style="float:left; width:59%; margin-right:1%;">
            <p><label for="<?php echo $this->get_field_id('cclass'); ?>">Classes:</label>
            <input id="<?php echo $this->get_field_id('cclass'); ?>" name="<?php echo $this->get_field_name('cclass'); ?>" type="text" class="widefat" style="width:92%;" value="<?php echo $cclass;?>" /></p>  
        </div>
    	<div style="float:left; width:40%;">
            <p><label for="<?php echo $this->get_field_id('minh'); ?>">Min-height:</label>
            <input id="<?php echo $this->get_field_id('minh'); ?>" name="<?php echo $this->get_field_name('minh'); ?>" type="text" class="widefat" style="width:99%;" value="<?php echo $minh;?>" /></p>  
        </div>
    </div>
    <p><label for="<?php echo $this->get_field_id('readmore'); ?>">Readmore Text:</label>
    <input id="<?php echo $this->get_field_id('readmore'); ?>" name="<?php echo $this->get_field_name('readmore'); ?>" type="text" class="widefat" value="<?php echo $readmore;?>" /></p>  
    <p><label for="<?php echo $this->get_field_id('more_link'); ?>">Readmore Link:</label>
    <input id="<?php echo $this->get_field_id('more_link'); ?>" name="<?php echo $this->get_field_name('more_link'); ?>" type="text" class="widefat" value="<?php echo $more_link;?>" /></p>  
    <a href="#" class="custom-text-less-option">Less options</a>
    </div>
    <br class="clear" style="margin-bottom:12px;" />
    <?php
	} 
	function update($new_instance, $old_instance) {
		return $new_instance;
	}
	function widget( $args, $instance ) {
		extract($args);
        $title      = isset($instance['title']) ? apply_filters('widget_title', $instance['title']) : '';
        $contentx   = isset($instance['contentx']) ? $instance['contentx'] : '';    $ptag   = isset($instance['ptag']) ? $instance['ptag'] : '';
        $cclass     = isset($instance['cclass']) ? $instance['cclass'] : '';        $minh   = isset($instance['minh']) ? $instance['minh'] : '';
        $cols       = isset($instance['cols']) ? $instance['cols'] : '';        $nth    = isset($instance['nth']) ? $instance['nth'] : '';
        $readmore   = isset($instance['readmore']) ? $instance['readmore'] : '';
        $more_link  = isset($instance['more_link']) ? $instance['more_link'] : '';
		$minh_style = $nthCls = '';
		if ($readmore == '') $readmore = 'Read More'; 
		if ($cclass != '') $cclass	= ' '.$cclass; 
		if ($cols	!= '') $cols 	= ' '.$cols;
		if ($nth != 'none') $nthCls	= ' '.$nth;
		if ($minh != '' && $minh != '-1' && $minh != '0') 
		$minh_style = ' style="min-height:'.$minh.'px"';
		
		// Before widget overide
		$clsOveride = 'class="wgs'.$cols.$cclass.$nthCls;
		echo str_replace(array('_', 'custom-text', 'class="wgs'), array('-', 'csbox', $clsOveride), $before_widget);
		if ( $title ) echo $before_title . $title . $after_title;
		echo '<div class="cstext"'.$minh_style.'>';
			if ($ptag == 'on') { echo wpautop(do_shortcode($contentx)); } else { echo do_shortcode($contentx); }
        echo '</div>';
		if ($more_link) echo '<div class="csmore"><a href="'.$more_link. '" class="button btn-csmore"><span>'.$readmore.'</span></a></div>';		
		echo $after_widget;
	} 
}
## FlexSlider Widget @since 1.1 @version 1.4
class flexslider extends WP_Widget {
    function __construct() {
        $widgets_opt = array('description'=>'Display flexslider in widget (v1.4)');
        parent::__construct(false,$name= "Theme - Flex Slider",$widgets_opt);
    }
    function form($instance) {
        $title_show = isset($instance['title_show']) ? esc_attr($instance['title_show']) : '';
        $desc_show  = isset($instance['desc_show']) ? esc_attr($instance['desc_show']) : '';
        $btn_show   = isset($instance['btn_show']) ? esc_attr($instance['btn_show']) : '';
        $groups     = isset($instance['groups']) ? esc_attr($instance['groups']) : '';
        $effects    = isset($instance['effects']) ? esc_attr($instance['effects']) : '';
        $shownavi   = isset($instance['shownavi']) ? esc_attr($instance['shownavi']) : '';
        $shownavi2  = isset($instance['shownavi2']) ? esc_attr($instance['shownavi2']) : '';
        $animation  = isset($instance['animation']) ? esc_attr($instance['animation']) : '';
        $types      = isset($instance['types']) ? esc_attr($instance['types']) : '';
        $styles     = isset($instance['styles']) ? esc_attr($instance['styles']) : '';
        $maxheight  = isset($instance['maxheight']) ? esc_attr($instance['maxheight']) : '';
        $times      = isset($instance['times']) ? esc_attr($instance['times']) : '';
    ?>
    <div style="width:100%; overflow:hidden;">
        <p><label for="<?php echo $this->get_field_id('groups'); ?>">Groups of Slider:</label>
        <select id="<?php echo $this->get_field_id('groups'); ?>" name="<?php echo $this->get_field_name('groups'); ?>" class="widefat">
            <option value="">No Specific Group</option>
            <?php $slidegroups = get_terms('groups', array('hide_empty' => false, 'orderby' => 'id')); $groupcount = count($slidegroups);
            if ($groupcount > 0) {
                foreach ($slidegroups as $g) { ?>
                <option value="<?php echo $g->slug; ?>"<?php if ($groups==$g->slug) echo ' selected="selected"'; ?>><?php echo $g->name; ?></option>
                <?php }
            }
            echo $groups;?>
        </select></p>
        <p><strong>Caption Display Option</strong> &nbsp; <small>(Tick to show)</small></p>
        <div style="float:left; width:33%; margin-top:-15px;">
            <p><input class="checkbox" type="checkbox" <?php if ($title_show == "on") echo "checked";?> id="<?php echo $this->get_field_id('title_show'); ?>" name="<?php echo $this->get_field_name('title_show'); ?>" /><label for="<?php echo $this->get_field_id('title_show'); ?>"> Title?</label></p>
        </div>
        <div style="float:left; width:33%; margin-top:-15px;">
            <p><input class="checkbox" type="checkbox" <?php if ($desc_show == "on") echo "checked";?> id="<?php echo $this->get_field_id('desc_show'); ?>" name="<?php echo $this->get_field_name('desc_show'); ?>" /><label for="<?php echo $this->get_field_id('desc_show'); ?>"> Desc?</label></p>
        </div>
        <div style="float:left; width:33%; margin-top:-15px;">
            <p><input class="checkbox" type="checkbox" <?php if ($btn_show == "on") echo "checked";?> id="<?php echo $this->get_field_id('btn_show'); ?>" name="<?php echo $this->get_field_name('btn_show'); ?>" /><label for="<?php echo $this->get_field_id('btn_show'); ?>"> CTA?</label></p>
        </div>
        <hr  style="border:0 none; border-bottom:1px solid #CCC; clear:both;" />
    </div>
    <div style="width:100%; overflow:hidden;">
        <div style="float:left; width:50%; margin-top:-8px;">
            <p><input class="checkbox" type="checkbox" <?php if ($shownavi == "on") echo "checked";?> id="<?php echo $this->get_field_id('shownavi'); ?>" name="<?php echo $this->get_field_name('shownavi'); ?>" /><label for="<?php echo $this->get_field_id('shownavi'); ?>"> Hide Next/Prev?</label></p>
        </div>
        <div style="float:left; width:50%; margin-top:-8px;">
            <p><input class="checkbox" type="checkbox" <?php if ($shownavi2 == "on") echo "checked";?> id="<?php echo $this->get_field_id('shownavi2'); ?>" name="<?php echo $this->get_field_name('shownavi2'); ?>" /><label for="<?php echo $this->get_field_id('shownavi2'); ?>"> Hide Pagination?</label></p>
        </div>
        <div style="float:left; width:100%; margin-top:-16px;">
        <p><input class="checkbox" type="checkbox" <?php if ($animation == "on") echo "checked";?> id="<?php echo $this->get_field_id('animation'); ?>" name="<?php echo $this->get_field_name('animation'); ?>" /><label for="<?php echo $this->get_field_id('animation'); ?>"> WayPoint Animation? <small>(If not work, ask devs)</small></label></p>
        </div>
    </div>
    <div style="width:100%; overflow:hidden; margin-top:-15px;">
        <div style="float:left; width:40%; margin-right:2%;">
            <p><label for="<?php echo $this->get_field_id('types'); ?>">Types:</label>
            <select name="<?php echo $this->get_field_name('types'); ?>" id="<?php echo $this->get_field_id('types'); ?>" class="widefat">
                <option value="fullwidth"<?php if ($types == 'fullwidth') { echo ' selected="selected"'; } ?>>Fullwide</option>
                <option value="regular"<?php if ($types == 'regular') { echo ' selected="selected"'; } ?>>Regular</option>
                <option value="boxed"<?php if ($types == 'boxed') { echo ' selected="selected"'; } ?>>Boxed</option>
                <option value="fullwidex"<?php if ($types == 'fullwidex') { echo ' selected="selected"'; } ?>>Fullwide Alt</option>
            </select></p>
		</div>
        <div style="float:left; width:24%; margin-right:2%;">
            <p><label for="<?php echo $this->get_field_id('effects'); ?>">Effects:</label>
            <select name="<?php echo $this->get_field_name('effects'); ?>" id="<?php echo $this->get_field_id('effects'); ?>" class="widefat">
                <option value="fade"<?php if ($effects == 'fade') { echo ' selected="selected"'; } ?>>Fade</option>
                <option value="slide"<?php if ($effects == 'slide') { echo ' selected="selected"'; } ?>>Slide</option>
            </select></p>  
        </div>
        <div style="float:left; width:32%;">
            <p><label for="<?php echo $this->get_field_id('styles'); ?>">Style:</label>
            <select name="<?php echo $this->get_field_name('styles'); ?>" id="<?php echo $this->get_field_id('styles'); ?>" class="widefat">
                <option value="nil"<?php if ($styles == 'nil') { echo ' selected="selected"'; } ?>>Default</option>
                <option value="alt"<?php if ($styles == 'alt') { echo ' selected="selected"'; } ?>>Alternet</option>
            </select></p>  
        </div>
    </div>
    <div style="width:100%; overflow:hidden; margin-top:-15px;">
    	<div style="float:left; width:48%; margin-right:2%;">
            <p><label for="<?php echo $this->get_field_id('times'); ?>">Time Interval:</label>
            <input id="<?php echo $this->get_field_id('times'); ?>" name="<?php echo $this->get_field_name('times'); ?>" type="text" class="widefat" value="<?php echo $times;?>" /><br /><small>Default - 6000</small></p>
        </div>
    	<div style="float:left; width:48%; margin-left:2%;">
            <p><label for="<?php echo $this->get_field_id('maxheight'); ?>">Max Height (px):</label>
            <input id="<?php echo $this->get_field_id('maxheight'); ?>" name="<?php echo $this->get_field_name('maxheight'); ?>" type="text" class="widefat" value="<?php echo $maxheight;?>" /><br /><small>Default = 0 (disable)</small></p>
        </div>
    </div>
    <?php
	} 
	function update($new_instance, $old_instance) {
		return $new_instance;
	}
    function widget( $args, $instance ) {
        extract($args);
        global $post;
        $desc_show  = isset($instance['desc_show']) ? $instance['desc_show'] : '';  $title_show = isset($instance['title_show']) ? $instance['title_show'] : '';
        $btn_show   = isset($instance['btn_show']) ? $instance['btn_show'] : '';    $groups     = isset($instance['groups']) ? $instance['groups'] : '';
        $effects    = isset($instance['effects']) ? $instance['effects'] : '';      $shownavi   = isset($instance['shownavi']) ? $instance['shownavi'] : '';
        $shownavi2  = isset($instance['shownavi2']) ? $instance['shownavi2'] : '';  $animation  = isset($instance['animation']) ? $instance['animation'] : '';
        $times      = isset($instance['times']) ? $instance['times'] : '';      $types      = isset($instance['types']) ? $instance['types'] : '';
        $maxheight  = isset($instance['maxheight']) ? $instance['maxheight'] : '';  $styles     = isset($instance['styles']) ? $instance['styles'] : '';
		
		if($maxheight =='' || $maxheight =='0' || $maxheight =='-1') { $maxheight = ''; $sclass = ''; }
		else { $maxheight = ' style="max-height:'.$maxheight.'px"'; $sclass = ' has-mh'; }
		
		$groupid = ($groups!='') ? 'i'.$groups : 'eflex'; 
		if ($types=='regular' || $types=='boxed') $cls = '';
		$groups = ($groups !='') ? '&groups='.$groups : '';
		$slidequery = 'post_type=slides'.$groups.'&posts_per_page=-1&post_status=publish&order=ASC&orderby=menu_order';
		query_posts($slidequery); $i = 0;
		if (have_posts()) : 
		echo '<div class="section islider slider-header slider-'.$types.'">';
		if ($types == 'regular') echo '<div class="main slider-container">';
		echo '<div class="eslider-'.$groupid.' flexslider'.$sclass.'"'.$maxheight.'><ul id="'.$groupid.'" class="slides">';
		
		while ( have_posts() ) : the_post(); $i++;
            $before_a = $before_al = $after_a = $after_al = $target_a = $target_al = $bf_a = $af_a = '' ;
            $link_slide     = meta_options('link_slide') ? meta_options('link_slide') : '';
            $target_slide   = meta_options('link_target') ? meta_options('link_target') : '';
            $link_btn       = meta_options('btn_link') ? meta_options('btn_link') : '';
            $target_btn     = meta_options('btn_target') ? meta_options('btn_target') : '';
            $btn_tx         = meta_options('btn_text') ? meta_options('btn_text') : '';
			if ($btn_tx == '')  { $btn_tx = 'Read More'; }
			if ($target_slide == 'new_page') { $target_a = ' target="_blank"'; }
			if ($target_btn == 'new_page') { $target_al = ' target="_blank"'; }
			if ($link_slide !='') {
				$bf_a = '<a href="'.$link_slide.'"'.$target_a.'>';
				$af_a = '</a>';
			} 
			if ($link_btn !='') {
				$bf_al = '<a href="'.$link_btn.'"'.$target_al.' class="button btn-action">';
				$af_al = '</a>';
			} 
			$scaption 	= ' '.meta_options('slide_caption');
			$salign 	= cssclass(meta_options('slide_align'), 'al');
			$sposition 	= cssclass(meta_options('slide_position'), 'ps');
			$scolor 	= cssclass(meta_options('slide_color'), 'cl');
			$bgcolor 	= cssclass(meta_options('slide_bgcolor'), 'bg');
			$sclass 	= cssclass(meta_options('slide_class'), 'ov');
			if ($types == 'fullwidth' || $types == 'fullwidex') $sclass .= ' tp-fw';
			
			$isliderx = '<li class="slide slide'.$i.'">';
			if($title_show == 'on' || $desc_show == 'on') {
				$t_count = strlen(get_the_title());
				$c_count = strlen(get_the_content());
				if (($title_show == 'on' && $t_count != 0) || ($desc_show == 'on' && $c_count != 0) || ($link_btn !='' && $btn_show == 'on')) {
					$isliderx .= '<div class="ov '.$sposition.$sclass.$scaption.'">';
					if ($types == 'fullwidth' || $types == 'fullwidex') { $isliderx .= '<div class="main">'; }
					$isliderx .= '<div class="cpn '.$scolor.$bgcolor.$salign.' st-'.$styles.'">';
						if($title_show == 'on' && $t_count != 0) { 
							$isliderx .= '<div class="title animate"><h3>'.get_the_title().'</h3>';
							if ($styles=='alt' && $btn_show=='on' && $link_btn!='') {$isliderx .='<div class="cta">'.$bf_al.$btn_tx.$af_al.'</div>';}
							$isliderx .= '</div>'; 
						}
						if($desc_show == 'on' && $c_count != 0) {$isliderx .= '<div class="content animate">'.wpautop(do_shortcode(get_the_content())).'</div>';}
						if($styles!='alt' && $btn_show=='on' && $link_btn!='') {$isliderx .='<div class="cta animate">'.$bf_al.$btn_tx.$af_al.'</div>';}
					$isliderx .= '</div>';
					if ($types == 'fullwidth'|| $types == 'fullwidex') { $isliderx .= '</div>'; }
					$isliderx .= '</div>';
				}
			}
			$isliderx .= '<div class="thumbs">'.$bf_a.'<img src="' .thumb_url_src($post->ID). '" alt="" />'.$af_a.'</div>'; 
			$isliderx .= '</li>';
			echo $isliderx; 
		endwhile;
		
		echo '</ul></div>'; ?>
		<script type="text/javascript">
		jQuery(document).ready(function($) {
			<?php if ($animation == 'on') : ?>
			function ani() {
				$('.eslider-<?php echo $groupid; ?> li .title, .eslider-<?php echo $groupid; ?> li .content, .eslider-<?php echo $groupid; ?> li .cta').removeClass('fadeInRight').css('visibility', 'hidden');
				$('.eslider-<?php echo $groupid; ?> li.flex-active-slide .title, .eslider-<?php echo $groupid; ?> li.flex-active-slide .content, .eslider-<?php echo $groupid; ?> li.flex-active-slide .cta').addClass('fadeInRight').css('visibility', 'visible');
				$('.eslider-<?php echo $groupid; ?> li.flex-active-slide .content').css({'-webkit-animation-delay': '.4s', '-moz-animation-delay': '.4s', '-o-animation-delay': '.4s', '-ms-animation-delay': '.4s','animation-delay': '.4s'});
				$('.eslider-<?php echo $groupid; ?> li.flex-active-slide .cta').css({'-webkit-animation-delay': '.6s', '-moz-animation-delay': '.6s', '-o-animation-delay': '.6s', '-ms-animation-delay': '.6s','animation-delay': '.6s'});
			};
			ani();
			<?php endif; ?>
			$(".eslider-<?php echo $groupid; ?>").flexslider({
				controlNav: <?php if ($shownavi2 == 'on') echo 'false'; else echo 'true'; ?>,
				directionNav: <?php if ($shownavi == 'on') echo 'false'; else echo 'true'; ?>,
				animation: "<?php echo $effects; ?>",
				easing: "swing",
				direction: "horizontal",
				slideshow: <?php if ($times == '0') echo 'false'; else echo 'true'; ?>,
				slideshowSpeed: <?php if ($times !='') echo $times; else echo '6000'; ?>,
				animationSpeed: 700,
				pauseOnAction: true,
				pauseOnHover: false,
				useCSS: false, 
				touch: true,
				manualControls: '',
				start: function () { <?php if ($animation == 'on') echo 'ani();'; ?> },
				after: function(){ <?php if ($animation == 'on') echo 'ani();'; ?> },
				mousewheel: false
			});
		});
		</script>
        <?php if ($types == 'regular') echo '</div>';
		echo '</div>';
		endif; wp_reset_query();
	} 
}