<?php
/* @package ThemeNio @ver/1.6
 * @copyright ThemeNio
 * @version - 1.0.1
 *
 * !Important Note: All the core function available in core folder 
 * !DO NOT edit core function without permision
 * !OR you CAN create your own function here
 *
**/
// Nav location register.
register_nav_menus( array(
	'secondary' => 'Footer Menu',
	'top-nav' => 'Top Nav',
	'top-nav-logged' => 'Top Nav Logged',
));
register_sidebar( array(
	'id' => 'top-call-to-action',
	'name' => __('Call To Action'),
	'description' => 'The is for Top call to action', 
	'before_widget' => '<div class="wgs wgs-cta %2$s %1$s">', 
	'after_widget' => '</div>', 
	'before_title' => '<h3 class="wg-title"><span>',
	'after_title' => '</span></h3>',
));
register_sidebar( array(
	'id' => 'bottom-widget',
	'name' => __('Bottom Widget'),
	'description' => 'The widget for bottom',
	'before_widget' => '<div class="wgs wgs-footer wgs-af %2$s %1$s"><div class="bottom-inner">',
	'after_widget' => '</div></div>',
	'before_title' => '<h4 class="wg-title">',
	'after_title' => '</h4>',
));
register_sidebar( array(
	'id' => 'bottom-widget-top',
	'name' => __('Bottom Widget Top'),
	'description' => 'The widget for bottom top',
	'before_widget' => '<div class="wgs wgs-footer wgs-top %2$s %1$s"><div class="bottom-inner">',
	'after_widget' => '</div></div>',
	'before_title' => '<h4 class="wg-title">',
	'after_title' => '</h4>',
));
register_sidebar( array(
	'id' => 'slideshow',
	'name' => __('Slideshow'),
	'description' => 'The area front page slider.',
	'before_widget' => '',
	'after_widget' => '',
	'before_title' => '',
	'after_title' => '',
));
//contact form on slideshow
register_sidebar( array(
	'id' => 'banner-widget',
	'name' => __('Banner Overlay'),
	'description' => 'The area for page slider.',
	'before_widget' => '<div class="banner-overlay %2$s %1$s">',
	'after_widget' => '</div>',
	'before_title' => '<h3 class="banner-title">',
	'after_title' => '</h3>',
));
// Feature Widget
register_sidebar( array(
	'id' => 'feature-widget',
	'name' => __('Feature Widget'),
	'description' => 'The area for displaing feature widget.',
	'before_widget' => '<div class="feature-wgs %2$s %1$s">',
	'after_widget' => '</div>',
	'before_title' => '<h3 class="feature-title">',
	'after_title' => '</h3>',
));
// Widget
register_sidebar( array(
	'id' => 'service-area',
	'name' => __('Service Area'),
	'description' => 'The area for displaing service area.',
	'before_widget' => '<div class="service-area-wgs %2$s %1$s">',
	'after_widget' => '</div>',
	'before_title' => '<h3 class="service-area-title">',
	'after_title' => '</h3>',
));
// Post thumbnail support
add_theme_support( 'post-thumbnails' );
// Custom Thumbnail Size Define
if (function_exists( 'add_image_size' )) {
	add_image_size('team-thumbs', 475, 480, true);
	add_image_size('quote-thumbs', 200, 200, true);
}
// tel_link @since 1.6 @version 1.0 
function tel_link($num=null) {
	$out = '';
	$arr = array("(", ")", "-", ".", " ", "T", "P", "C", "Cell", "Toll", "Phone", "CELL", "TOLL", "PHONE");
	if ($num !=null) { 
		$out = str_replace($arr, "", $num);
	}
	return $out;
}
// is_iblog @since 1.6 @version 1.0 
function is_iblog() {
	global $post, $wp;
	if (is_home() || is_archive() || is_singular('post') || is_page_template('page-blog.php'))
		return true;
	else
		return false;
}
// is_ishop @since 1.6 @version 1.0 
function is_ishop() {
	if ( !class_exists( 'woocommerce' ) )
	return false;
	
	global $woocommerce;
	if (is_shop() || is_woocommerce() || is_cart() || is_checkout() || is_account_page() || is_product() || is_page_template('page-woo.php'))
	return true;
}
// nio_body_class @since 1.6 @version 1.0 #Body Styles
function nio_body_class ($classes) {
	$lang = ' lang-'.substr(get_bloginfo('language'), 0, 2);
	$classes[] = browser();
	$classes[] = $lang;
	$classes[] = sticky_header(false);
	return $classes;
}
add_filter('body_class', 'nio_body_class');
// wrap_class @since 1.6 @version 1.1 #Wrap Style
function wrap_class($echo=true) {
	$wclass = ' ';
	if (is_home())											: $wclass .= 'main-ipage blog-ipage'; 
	elseif (is_front_page()) 								: $wclass .= 'main-ipage front-ipage'; 
	elseif (is_page_template('page-blog.php')) 				: $wclass .= 'main-iblog blog-ipage'; 
	elseif (is_page_template('page-wider.php')) 			: $wclass .= 'wider-ipage inside-ipage'; 
	elseif (is_page_template('page-contact.php')) 			: $wclass .= 'contact-ipage inside-ipage'; 
	else 													: $wclass .= 'inside-ipage'; endif;
	
	if ($echo==true) 
		echo $wclass;
	else 
		return $wclass;
}
// ititles @since 1.6 @version 1.0 #Banner/Header Title
function ititles ($title='', $default=false, $heading='h2') {
	global $headerOption; $titles = $get_title = ''; 
	// Option
	$hs_alter = (mo('title-alter')!='') ? mo('title-alter') : 'off';
	$pos = (mo('title-position')!='') ? mo('title-position') : 'left';
	if ($hs_alter=='on' || $default==1 || $default==true) $get_title = get_the_title();
	 
	// Main Title
	if ($title!=''||$title!=null)
		$hs_main = ($title!='') ? $title : ''; 
	else
		$hs_main = (mo('main-title')) ? mo('main-title') : $get_title; 
	// Sub Title
	$hs_sub = (mo('sub-title')!='') ? mo('sub-title') : ''; 
	// Titles Join
	if ($hs_main!='')
		$titles .= '<'.$heading.' class="title title-alter"><span>'.$hs_main.'</span></'.$heading.'>';
	if ($hs_sub!='')
		$titles .= '<p class="title-sub">'.$hs_sub.'</p>';
	
	// Header Button - for Advance Option
	if ($headerOption=='advanced') {
		$hs_url = mo('header-btnurl');
		$hs_txt = (mo('header-btntxt')) ? mo('header-btntxt') : 'Read More';
		$hs_tgt = (mo('header-btntab')=='on') ? ' target="_blank"' : '';
		if ($hs_url!='')
			$titles .= '<p class="cta"><a class="button btn-header" href="'.$hs_url.'"'.$hs_tgt.'>'.$hs_txt.'</a></p>'; 
	}
	// If title blank
	if ($titles=='') {
		return false;
	} else {
		return '<div class="cpn cpn al-'.$pos.'">'.$titles.'</div>';
	}
}
// ibanner @since 1.6 @version 1.0 #Banner/Header Image
function ibanner ($image='', $default=false) {
	$image_src = $bg_default = ''; 
	
	if ($default==1||$default==true) 
		$bg_default = ao('headerbg');
	
	if ($image!=''||$image!=null)
		$image_src = ($image!='') ? $image : $bg_default;
	else
		$image_src = (mo('headerbg') !='') ? mo('headerbg') : $bg_default;
	
	// If image blank
	if ($image_src=='') {
		return false;
	} else {
		return $image_src;
	}
}
// header_class @since 1.6 @version 1.3 #Header Style
function header_class ($echo=true) {
	global $headerOption; 
	$hclass = '';
	// Get Specific Variable
	$glbhead 		= 'global';
	$header_bg		= ( mo ('headerbg') != '' ) ? mo ('headerbg') : ao ('headerbg');
	$is_title		= mo ('main-title') ? mo ('main-title') : '';
	$is_subtitle	= mo ('sub-title') ? mo ('sub-title') : '';
	// Basic Style
	if ($headerOption=='basic') {
		$header_style 	= ao ('header-style') ? ao ('header-style') : '';
		$header_sticky	= ao ('header-sticky') ? ao ('header-sticky') : '';
	}
	// Advanced Style
	if ($headerOption=='advanced') {
		// Page Meta
		$glbhead 		= 'custom';
		$header_style	= mo ('header-style') ? mo ('header-style') : '';
		$header_sticky	= mo ('header-sticky') ? mo ('header-sticky') : '';
		$header_skin	= mo ('header-skin') ? mo ('header-skin') : '';
		$header_trans	= mo ('header-trans') ? mo ('header-trans') : '';
		$header_top		= mo ('header-tophide') ? mo ('header-tophide') : '';
		// Global/Fallback Meta
		if (mo ('header-style') == 'style0' || mo ('header-style') == '') {
			$glbhead 		= 'global';
			$header_style 	= ao ('header-style') ? ao ('header-style') : '';
			$header_sticky	= ao ('header-sticky') ? ao ('header-sticky') : '';
			$header_skin	= ao ('header-skin') ? ao ('header-skin') : '';
			$header_trans	= ao ('header-trans') ? ao ('header-trans') : '';
			$header_top		= ao ('header-tophide') ? ao ('header-tophide') : '';
		}
	}
	
	$hclass .= cssclass($glbhead, 'header');
	$hclass .= cssclass($header_style, 'header');
	if ( $header_sticky != '' ) $hclass .= cssclass($header_sticky, 'sticky');
	if ( is_active_sidebar('slideshow') && is_front_page() ) $hclass .= cssclass('has', 'slider');
	
	// Advance class
	if ($headerOption=='advanced') {
		if ( $header_skin != '' ) $hclass .= cssclass($header_skin, 'skin');
		if ( $header_trans !='' && $header_style == 'style2' ) $hclass .= cssclass($header_trans, 'trans');
		if ( $header_top != '' ) $hclass .= cssclass($header_top, 'topbar');
	}
	
	// Title/Banner class
	$bnopt = (ao('header-opt')=='yes') ? true : false;
	$ibanner = ibanner(ao('headerbg-blog'), $bnopt); $bn_title = ititles(ao('title-blog'), $bnopt);
	if (is_front_page() && is_active_sidebar( 'slideshow')) {
		$hclass .= cssclass('has','banner','',1,1); $hclass .= cssclass('no','titles','',1,1);
	} elseif ( is_page() && !is_page_template('page-blog.php') ) {
		if ($header_bg == '') { $hclass .= cssclass('no','banner','',1,1); } else { $hclass .= cssclass('has','banner','',1,1); }
		if ($is_title != '' || $is_subtitle != '') { $hclass .= cssclass('has','titles','',1,1); } else { $hclass .= cssclass('no','titles','',1,1); }
	} elseif ( is_home()||is_search()||is_single()||is_archive()||is_page_template('page-blog.php')|| is_singular('post') && ($ibanner||$bn_title) ) {
		if ($ibanner) $hclass .= cssclass('has','banner','',1,1); else  $hclass .= cssclass('no','banner','',1,1);
		if ($bn_title) $hclass .= cssclass('has','titles','',1,1); else  $hclass .= cssclass('no','titles','',1,1);
	} else {
		$hclass .= cssclass('no','banner','',1,1); $hclass .= cssclass('no','titles','',1,1);
	}
	
	// Output class
	if ( $echo==true ) echo $hclass;
	else return $hclass;
}
// Sticky class for Header Style @since 1.6 @version 1.0
function sticky_header ($echo=true) {
	$sclass = '';
	if (mo ('header-style') == 'style0' || mo ('header-style') == '') {
		if ( ao ('header-sticky') == 'yes') 
		$sclass .= ' is-sticky';
	} else {
		if ( mo ('header-sticky') == 'yes') 
		$sclass .= ' is-sticky';
	}	
	if ($echo==true) 
		echo $sclass;
	else 
		return $sclass;
}
// Site Logo @since 1.6 @version 1.0
function site_logo ($x=null, $x2=null) {
	$logo = $logo_url = $cl = $logo2x = ''; 
	$skin = 'dark'; $skin_d = 'dark'; 
	
	// Define Logo
	$main_logo = ao('logo');
	if ( ($x2 == true || $x2 == '2x') && $x == '' ) 
		$logo2x = get_template_directory_uri().'/images/logo2x.png';
		
	if ($x == null || $x == '') 
		$x = get_template_directory_uri().'/images/logo.png';
		
	if (ao('logo-light') =='' && ao('logo-dark') =='' && ao('logo') =='') 
		$main_logo = $x;
	
	// Define Skin
	if (mo ('header-skin') == 'light') 
		$skin = 'light';
	if (ao ('header-skin') == 'light') 
		$skin_d = 'light'; 
	// Set Default/Fallback Logo
	$logo_url = $main_logo; 
	$logo_url2x = $logo2x; 
	$cl = 'logo-default';
	
	//Override Logo
	if (mo ('header-style') == 'style0') {
		// Global Logo - get from theme option
		if ($skin_d == 'light' && ao('logo-dark') !='' && ao('header-style') == 'style2') { 
			$logo_url = ao('logo-dark'); 
			$cl = 'logo-dark';
		} elseif ($skin_d == 'dark' && ao('logo-light') !='' && ao('header-style') == 'style2') { 
			$logo_url = ao('logo-light'); 
			$cl = 'logo-light'; 
		} else { 
			if ($main_logo !='')
			$logo_url = $main_logo;
		}
	} else {
		//Override logo - get from relevant page option
		if (mo ('header-style') == 'style2') {
			if ($skin == 'light' && ao('logo-dark') !='') { 
				$logo_url = ao('logo-dark'); 
				$cl = 'logo-dark';
			} elseif ($skin == 'dark' && ao('logo-light') !='') { 
				$logo_url = ao('logo-light'); 
				$cl = 'logo-light'; 
			}
		}
	}
	if ($logo_url2x)
	$logo .= '<img class="logo-moblet logo-2x on-phone on-tablet" src="'.$logo_url2x.'" alt="'.get_bloginfo('name').'">';
	
	$logo .= '<img class="logo-main '.$cl.'" src="'.$logo_url.'" alt="'.get_bloginfo('name').'">';
	echo $logo;
}
// Social Links @since 1.6 @version 1.1
function social_link ($echo=true, $title=false, $icon = true) {
	$social = '';
	// Get Social Links from admin option and set with array
	$SM = array( 'fb' => ao('fb_link'), 'hz' => ao('hz_link'), 'tw' => ao('tw_link'), 'in' => ao('in_link'), 'bb' => ao('bb_link'), 'gp' => ao('gp_link'),
					'pi' => ao('pi_link'), 'ig' => ao('ig_link'), 'vm' => ao('vm_link'), 'yt' => ao('yt_link'), 'sc' => ao('sc_link') );
	if ( $SM['fb'] !='' ) {
	$social .= '<span class="link"><a href="'.$SM['fb'].'" target="_blank" title="Facebook">';
		if ($icon == true) $social .= '<i class="icon icon-fb fa fa-facebook"></i>';
		if ($title == true) $social .= '<span class="title">Facebook</span>';
	$social .= '</a></span>';
	}
	
	if ( $SM['tw'] !='' ) {
	$social .= '<span class="link"><a href="'.$SM['tw'].'" target="_blank" title="Twitter">';
		if ($icon == true) $social .= '<i class="icon icon-tw fa fa-twitter"></i>';
		if ($title == true) $social .= '<span class="title">Twitter</span>';
	$social .= '</a></span>';
	}
	
	if ( $SM['pi'] !='' ) {
	$social .= '<span class="link"><a href="'.$SM['pi'].'" target="_blank" title="Pinterest">';
		if ($icon == true) $social .= '<i class="icon icon-pi fa fa-pinterest"></i>';
		if ($title == true) $social .= '<span class="title">Pinterest</span>';
	$social .= '</a></span>';
	}
	
	if ( $SM['in'] !='' ) {
	$social .= '<span class="link"><a href="'.$SM['in'].'" target="_blank" title="LinkedIn">';
		if ($icon == true) $social .= '<i class="icon icon-in fa fa-linkedin"></i>';
		if ($title == true) $social .= '<span class="title">LinkedIn</span>';
	$social .= '</a></span>';
	}
	
	if ( $SM['yt'] !='' ) {
	$social .= '<span class="link"><a href="'.$SM['yt'].'" target="_blank" title="YouTube">';
		if ($icon == true) $social .= '<i class="icon icon-yt fa fa-youtube-play"></i>';
		if ($title == true) $social .= '<span class="title">YouTube</span>';
	$social .= '</a></span>';
	}
	
	if ( $SM['ig'] !='' ) {
	$social .= '<span class="link"><a href="'.$SM['ig'].'" target="_blank" title="Instagram">';
		if ($icon == true) $social .= '<i class="icon icon-ig fa fa-instagram"></i>';
		if ($title == true) $social .= '<span class="title">Instagram</span>';
	$social .= '</a></span>';
	}
	
	if ( $SM['hz'] !='' ) {
	$social .= '<span class="link"><a href="'.$SM['hz'].'" target="_blank" title="Houz">';
		if ($icon == true) $social .= '<i class="fa fa-houzz"></i>';
		if ($title == true) $social .= '<span class="title">Houzz</span>';
	$social .= '</a></span>';
	}
			
	if ( $SM['bb'] !='' ) {
	$social .= '<span class="link"><a href="'.$SM['bb'].'" target="_blank" title="BBB">';
		if ($icon == true) $social .= '<i class="icon icon-bb fa fa-bbb"></i>';
		if ($title == true) $social .= '<span class="title">BBB</span>';
	$social .= '</a></span>';
	}
	
	if ( $SM['gp'] !='' ) {
	$social .= '<span class="link"><a href="'.$SM['gp'].'" target="_blank" title="Google+">';
		if ($icon == true) $social .= '<i class="icon icon-gp fa fa-google-plus"></i>';
		if ($title == true) $social .= '<span class="title">Google+</span>';
	$social .= '</a></span>';
	}
	
	if ( $SM['vm'] !='' ) {
	$social .= '<span class="link"><a href="'.$SM['vm'].'" target="_blank" title="Vimeo">';
		if ($icon == true) $social .= '<i class="icon icon-vm fa fa-vimeo"></i>';
		if ($title == true) $social .= '<span class="title">Vimeo</span>';
	$social .= '</a></span>';
	}
	
	if ( $SM['sc'] !='' ) {
	$social .= '<span class="link"><a href="'.$SM['sc'].'" target="_blank" title="Snapchat">';
		if ($icon == true) $social .= '<i class="icon icon-sc fa fa-commenting"></i>';
		if ($title == true) $social .= '<span class="title">Snapchat</span>';
	$social .= '</a></span>';
	}
	
	if ($echo==true) 
		echo $social;
	else 
		return $social;
}
// Excerpt length modified 
add_filter('excerpt_length', 'nio_excerpt_length');
function nio_excerpt_length($length) {
	return 30; 
}
add_filter('excerpt_more', 'nio_excerpt_more');  
function nio_excerpt_more($text){  
	return '...';
}
// Term Meta option
function term_meta ($name='', $termID='') { 
	if ($name && $termID) {
		$meta = get_option("taxonomy_$termID");
		if (isset($meta[$name]) && $meta[$name] !='' )
		return $meta[$name];
	} else {
		return false;
	}
}  
// Developer Message
function nio_msg_admin () {  
    echo '<span id="footer-thankyou">Website Developed by (i) <a href="http://www.americancreative.com/" target="_blank">American Creative</a></span>';  
}  
add_filter('admin_footer_text', 'nio_msg_admin');
// Stylesheet & Scripts enqueue @since 1.6 @version 1.0
if (!is_admin()) {  
	function nio_enqueue() {
		wp_enqueue_script( 'waypoints', get_template_directory_uri().'/js/jquery.waypoints.js', true, '2.0.5');
		wp_enqueue_script( 'plugin', get_template_directory_uri().'/js/jquery.plugin.js', true, '1.1.5');
		//wp_enqueue_script( 'mixitup', get_template_directory_uri().'/js/jquery.mixitup.js', true, '2.1.8');

		wp_enqueue_script( 'scripts', get_template_directory_uri().'/js/jquery.init.js', true, '1.1.0');
		wp_enqueue_style( 'font-awesome', get_template_directory_uri().'/css/fa.css', true, '4.4');
		wp_enqueue_style( 'animate', get_template_directory_uri().'/css/animate.css', true, '1.1');
		wp_enqueue_style( 'other', get_template_directory_uri().'/css/others.css', true, '1.2');

	}    
	add_action('wp_enqueue_scripts', 'nio_enqueue');
}
// Dynamic Style Generate
if(!function_exists('dynamic_style')) {
	function dynamic_style() {
		global $headerOption; 
		// Get Specific Variable
		$style	= mo('header-style') ? mo('header-style') : '';
		$skin	= mo('header-skin') ? mo('header-skin') : '';
		$sticky	= mo('header-sticky') ? mo('header-sticky') : '';
		$top 	= mo('header-tophide') ? mo('header-tophide') : '';
		$trans	= mo('header-trans') ? mo('header-trans') : '';
		$height	= mo('headerbg-height') ? mo('headerbg-height') : '';
		$color	= mo('headerbg-color') ? mo('headerbg-color') : '';
		$bg		= mo('headerbg') ? mo('headerbg') : '';
		// Grid Extend Layout
		$gridCode = '';
		$gridEx = ao('grid-ex') ? ao('grid-ex') : '';
		//Debug purpose
		$geGridEx = isset($_GET['grid']) ? $_GET['grid'] : '';
		if ($geGridEx == 'lgx3' || $geGridEx == 'layout1') $gridEx = 'lgx3';
		elseif($geGridEx == 'lgx2' || $geGridEx == 'layout2') $gridEx = 'lgx2';
		
		// Grid with 20px gutter/margin
		if ($gridEx == 'lgx2') {
			$gridCode .= '@media (min-width: 1600px) { .grid, [class*="grid"] {margin-left:10px; margin-right:10px;} .main, .container {width:1440px;} .main-boxed {width:1480px;}'.
						 '.grid1 {width:100px;} .grid2 {width:220px;} .grid3 {width:340px;} .grid4 {width:460px;} .grid5 {width:580px;} .grid6 {width:700px;}'.
						 '.grid7 {width:820px;} .grid8 {width:940px;} .grid9 {width:1060px;} .grid10 {width:1180px;} .grid11 {width:1300px;}.grid12 {width:1420px;} }';
		}
		// Grid with 30px gutter/margin
		if ($gridEx == 'lgx3') {
			$gridCode .= '@media (min-width: 1600px) {.grid, [class*="grid"] {margin-left:15px; margin-right:15px;} .main, .container {width:1440px;} .main-boxed {width:1480px;}'.
						 '.grid1 {width:90px;} .grid2 {width:210px;} .grid3 {width:330px;} .grid4 {width:450px;} .grid5 {width:570px;} .grid6 {width:690px;}'.
						 '.grid7 {width:810px;} .grid8 {width:930px;} .grid9 {width:1050px;} .grid10 {width:1170px;} .grid11 {width:1290px;} .grid12 {width:1410px;}}';
		}
		// Generate Styles
		$out = '<style media="screen" type="text/css" id="dynamic-1x0">';
		$out .= $gridCode;
		
		// Advanced
		if ($headerOption=='advanced') {
			// Get Global Variable
			if(mo ('header-style') == 'style0' || mo ('header-style') == '' || is_search()) {
				$style 	= ao ('header-style') ? ao ('header-style') : '';
				$skin	= ao ('header-skin') ? ao ('header-skin') : '';
				$trans	= ao ('header-trans') ? ao ('header-trans') : '';
				$sticky	= ao ('header-sticky') ? ao ('header-sticky') : '';
				$top	= ao ('header-tophide') ? ao ('header-tophide') : '';
				if (is_search()) {
					$color	= ao ('headerbg-color') ? ao ('headerbg-color') : '';
				}
			}
			
			// Get Global Color Variable
			$color1 	= ( ao ('color1') != '' ) ? ao ('color1') : '#000000';
			$color2 	= ( ao ('color2') != '' ) ? ao ('color2') : '#252627';
			$color3 	= ( ao ('color3') != '' ) ? ao ('color3') : '#ffffff';
			if ($color=='')		$color	= ao ('headerbg-color');
			if (ao ('headerbg-color') == '' && mo ('headerbg-color') =='') $color = $color1;
			
			if ($trans == 100) { 	$alpha	= 1; } 		else { $alpha	= '.'.$trans; }
			if ($trans < 70) { 		$alpha_s = 70; } 	else { $alpha_s = $trans+5; }
	
			if ($bg=='')			$bg		= ao ('headerbg');
			
			$out .= '.header.masthead.header-'.$style.' { background-color:rgba('.hex2rgb($color).', '.$alpha.'); } ';
			$out .= '.ibanner .caption-static.no-overlay { background-color:'.$color.'} ';
	
			if ($height)
			$out .= '.ibanner .ebanner { max-height:'.$height.'; overflow:hidden; } ';
			
			if ( $color & $style=='style1' ) {
			$out .= '.header-style1.skin-dark {background-color:'.$color.';} ';
				
			$out .= '.header-style1.skin-light {background-color:'.$color3.';} ';
			}
			if ( $style=='style3' && $sticky=='yes' ) {
				$out .= '.header.header-style3.sticky-yes {box-shadow:0 0 3px #ccc; -moz-box-shadow:0 0 3px #ccc; -webkit-box-shadow:0 0 3px #ccc;} ';
			}
			if ( $style=='style2' ) {
				$out .= '.header-style2.masthead .iheader { position: absolute; z-index:99;} ';
				$out .= '.header-style2.masthead.no-banner.no-titles .iheader {position:static;} ';
				if (is_search()) {
					// $out .= '.search-results .header-style2.masthead.has-banner.has-titles .iheader {position:static;} ';
				}
				
				if ($trans == 0 && $bg=='') { 
					if ( $skin=='light' ) {
					$out .= '.header-style2.masthead.skin-light {background-color: '.$color3.'; color: '.$color.';} ';
					} else {
					$out .= '.header-style2.masthead.skin-dark {background-color: '.$color.'; color: '.$color3.';} ';
					}
				}
				if ( $skin=='light' ) {
					$out .= '.header-style2.skin-light {background-color: rgba('.hex2rgb($color3).', '.$alpha.'); color: '.$color1.';} ';				
					$out .= '.header-style2.skin-light .inav ul.menu > li > a {color: '.$color2.';} ';
					$out .= '.header-style2.skin-light .inav ul.menu > li > a:hover {color: '.$color1.';} ';
				} else {
					$out .= '.header-style2.skin-dark {background-color: rgba('.hex2rgb($color).', '.$alpha.'); color: '.$color3.';} ';
					$out .= '.header-style2.skin-dark .inav ul.menu > li > a {color: '.$color3.';} ';
					$out .= '.header-style2.skin-dark .inav ul.menu > li > a:hover {color: '.$color3.';} ';
				}
			}
			if ( $sticky=='yes' ) {
				$out .= '.header-sticky {position:fixed; top: -300px; z-index:99; display:block; transition: all 0.6s ease-in-out 0s; -webkit-transition: all 0.6s ease-in-out 0s; -moz-transition: all 0.6s ease-in-out 0s;} .header-sticky.fixed-now {top: 0;} .admin-bar .header-sticky.fixed-now {top:32px;} ';
				if ( $skin=='light' ) {
					$out .= '.header-sticky.skin-light {background-color:rgba('.hex2rgb($color3).', .'.$alpha_s.'); box-shadow:0 0 3px #ccc; -moz-box-shadow:0 0 3px #ccc; -webkit-box-shadow:0 0 3px #ccc; } ';
				} else {
					$out .= '.header-sticky.skin-dark {background-color:rgba('.hex2rgb($color).', .'.$alpha_s.');} ';
				}
			}
		} 
		// Basic Mode
		if ($headerOption=='basic') {
			// Get Global Variable
			$style 	= ao ('header-style');
			$sticky	= ao ('header-sticky');
			if ($bg=='')
			$bg		= ao ('headerbg');
			
			if (is_search())
			$color	= ao ('headerbg-color');
			// Color Variable
			$alpha	= '.7';
			$color1 	= ( ao ('color1') != '' ) ? ao ('color1') : '#000000';
			$color3 	= ( ao ('color3') != '' ) ? ao ('color3') : '#ffffff';
			if ($color=='')		$color	= ( ao ('headerbg-color') != '' ) ? ao ('headerbg-color') : '';
			if ($color)
			$out .= '.ibanner { background:'.$color.' } ';
			if ($height)
			$out .= '.ibanner .ebanner { max-height:'.$height.'; overflow:hidden; } ';
			if ( $style=='style2' ) {
				$out .= '.header-style2.masthead .site-header { position: absolute; z-index:99;} ';
				$out .= '.header-style2.masthead.no-banner.no-titles .site-header {position:static;} ';
			}
			if ( $sticky=='yes' ) {
				$out .= '.header-sticky {position:fixed; top: -300px; z-index:99; display:block; transition: all 0.6s ease-in-out 0s; -webkit-transition: all 0.6s ease-in-out 0s; -moz-transition: all 0.6s ease-in-out 0s;} .header-sticky.fixed-now {top: 0;} .admin-bar .header-sticky.fixed-now {top:32px;} ';
				$out .= '.header-sticky.sticky-yes {box-shadow:0 0 5px #999; -moz-box-shadow:0 0 5px #999; -webkit-box-shadow:0 0 5px #999;} ';
			}
		}
		$out .= '</style>';
		return $out;
	}
}
// empty_p  @since 1.0 @ver 1.0

function empty_p( $content ){
	return str_replace( array( '<p></p>', '<p> </p>', '<p>&nbsp;</p>' ), '', $content );
}
// clean_p @since 1.0 @ver 1.0

function clean_p( $content ) {
	$content = shortcode_unautop( $content );
	if ( substr( $content, 0, 4 ) == '</p>' )
		$content = substr( $content, 4 );
	if ( substr( $content, -3, 3 ) == '<p>' )
		$content = substr( $content, 0, -3 );
	return empty_p( $content );
}


// Added function to force WPs JQUERY to load in header instead of footer
function insert_jquery(){
	wp_enqueue_script('jquery', false, array(), false, false);
}
add_filter('wp_enqueue_scripts','insert_jquery', 1);