<?php
/* @package ThemeNio @ver/1.6.0 @file/1.1
 * @tags Custom meta-box for wordpress
 *
 * !Important Note: All the core function available in core folder 
 * !DO NOT edit core function without permision but you can disable those from bellow 
 * !OR you CAN create your own function here
 *
**/

// GET CURENT PAGE TEMPLATE
$post_ID = isset($_POST['post_ID']) ? $_POST['post_ID'] : '';
$cPostID = isset($_GET['post']) ? $_GET['post'] : $post_ID;
$get_template = get_post_meta($cPostID, '_wp_page_template',TRUE);
## Initialize Theme Default meta-box
## Page Title Hide Option
add_action( 'add_meta_boxes', 'titlemeta_option' );
// page title function init
function titlemeta_option() { 
	add_meta_box( 'titlemeta', 'Options for single page', 'titlemeta_func', 'page', 'side', 'default' ); 
}
## Header Meta Option 
add_action( 'add_meta_boxes', 'headermeta_option' );  
// headermeta function init
function headermeta_option() {
	add_meta_box( 'headermeta', 'Header Style Option', 'headermeta_func', 'page', 'normal', 'high' ); // for each page
	// add_meta_box( 'headermeta', 'Header Style Option', 'headermeta_func', 'post', 'normal', 'high' ); // for each post
}
## Blog Categoy Option (only for blog page template)
if ($get_template == 'page-blog.php')
add_action( 'add_meta_boxes', 'iblogmeta_option' );
// iblog function init
function iblogmeta_option() {  
	add_meta_box( 'iblogmeta', 'Blog Options', 'iblogmeta_func', 'page', 'normal', 'high' ); 
}
## CUSTOM META-BOX FOR THEME 

## Widgets Options @since 1.6 @version 1.0
add_action( 'add_meta_boxes', 'widgetmeta_option' );
function widgetmeta_option() { 
	add_meta_box( 'widgetmeta', 'Widgets Control', 'widgetmeta_func', 'page', 'side', 'default' ); 
	// add_meta_box( 'widgetmeta', 'Widgets Control', 'widgetmeta_func', 'product', 'side', 'default' ); 
}
function widgetmeta_func( $post ) {
	$values = get_post_custom( $post->ID );
	$bwgs = isset( $values['meta-bwgs'] ) ? esc_attr( $values['meta-bwgs'][0] ) : '';
	wp_nonce_field( 'wg_meta_box_nonce', 'wgmeta_box_nonce' );
	?>
	<p><label for="meta-bwgs"><input type="checkbox" name="meta-bwgs" id="meta-bwgs" <?php checked( $bwgs, 'off' ); ?> />Hide Bottom Widget</label></p>
	<?php
}

add_action( 'save_post', 'widgetmeta_save' );
function widgetmeta_save( $post_id ) {
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
	if( !isset( $_POST['wgmeta_box_nonce'] ) || !wp_verify_nonce( $_POST['wgmeta_box_nonce'], 'wg_meta_box_nonce' ) ) return;
	if( !current_user_can( 'edit_post', $post_id  ) ) return;
	// UPDATE
	$bwgs = ( isset( $_POST['meta-bwgs'] ) && $_POST['meta-bwgs'] ) ? 'off' : 'on';
	$bwgsc = ( isset( $_POST['meta-bwgs-c'] ) && $_POST['meta-bwgs-c'] ) ? 'off' : 'on';
	update_post_meta( $post_id, 'meta-bwgs', $bwgs );
}

if (class_exists('C_NextGEN_Bootstrap')) {
	## igalleryng @since 1.6.1 @version 1.0 @build - 160201#iO
	function igalleryng_func( $post ) {
		$values = get_post_custom( $post->ID );
		$ngid =  isset($values['ngid']) ? $values['ngid'][0] : '';
		wp_nonce_field( 'igallery_meta_box_nonce', 'igallery_box_nonce' );
		?>
		<div style="overflow:hidden;">
			<div style="width:100%; float:left;">
				<p><strong>Display NextGen Gallery</strong><br /><select class="widefat" id="ngid" name="ngid">
					<option value="hide"<?php if ($ngid=='hide') echo ' selected="selected"'; ?>>Hide Gallery</option>
					<?php
					global $nggdb, $wpdb;
					$nggal = $wpdb->get_results("SELECT gid, title FROM ".$wpdb->prefix."ngg_gallery ORDER BY gid ASC", ARRAY_A);
					// $nggal = $nggdb->find_all_galleries(); 
					$countgal = count($nggal);
					if ($countgal > 0) {
						foreach ($nggal as $ng) { ?>
							<option value="<?php echo $ng['gid']; ?>"<?php if ($ngid==$ng['gid']) echo ' selected="selected"'; ?>><?php echo $ng['title']; ?></option>
						<?php }
					} else {
						echo '<option value="0">No gallery found</option>';
					} ?>
				</select></p>
			</div>
		</div>
		<?php
	}
	add_action( 'save_post', 'igalleryng_save' );
	function igalleryng_save( $post_id ) {
		if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
		if( !isset( $_POST['igallery_box_nonce'] ) || !wp_verify_nonce( $_POST['igallery_box_nonce'], 'igallery_meta_box_nonce' ) ) return;
		if( !current_user_can( 'edit_post', $post_id ) ) return;
		// UPDATE
		update_post_meta( $post_id, 'ngid', $_POST['ngid']);
	}
	function igalleryng_option() {
		add_meta_box( 'igalleryng', 'Gallery Option', 'igalleryng_func', 'page', 'side', 'core' );
	}
	// if ($get_template == 'page-gallery.php')
	add_action( 'add_meta_boxes', 'igalleryng_option' );
	function gallery_name ($id=null) {
		if ($id==null) return false;
		global $wpdb;
		$get_gal = $wpdb->get_row("SELECT * FROM wp_ngg_gallery WHERE gid = $id");
		return $get_gal->title;
	}
}
