<?php
/* @package ThemeNio @ver/1.6.0 @file/1.1
 * @tags Custom post-type for wordpress
 *
 * !Important Note: All the core function available in core folder 
 * !DO NOT edit core function without permision but you can disable those from bellow 
 * !OR you CAN create your own function here
 *
**/
## Initialize Theme Default Post-type
// Slider
add_action('init', 'slides_register');
// Testimonial/Quotes
add_action('init', 'quotes_register');  
// Logos
add_action('init', 'logos_register'); 
// Teams
add_action('init', 'teams_register');  
## CUSTOM POST-TYPE FOR THEME 
function accordion_shortcode( $atts, $content) {
	$atts = shortcode_atts( array(
		'title' => '' ), $atts, 'accordion' );
	$id="accordion-".rand(10,99);
	return ' <div id="'.$id.'" class="accordion-area">'.do_shortcode(clean($content)).'</div>
 	 '."<script type=\"text/javascript\">
	 jQuery(document).ready(function() {
		var theFirst=jQuery('#{$id} .accordion-section:first-child>div:last-child');
		theFirst.slideDown(300).addClass('open'); 
		theFirst.prev('a').addClass('active');
		function close_accordion_section() {
			jQuery('#{$id} .accordion-section-title').removeClass('active');
			jQuery('#{$id} .accordion-section-content').slideUp(300).removeClass('open');
		}
	
	jQuery('#{$id} .accordion-section-title').click(function(e) {
		var currentAttrValue = jQuery(this).attr('href');
		if(jQuery(e.target).is('.active')) {
			close_accordion_section();
		}else {
			close_accordion_section();
			jQuery(this).addClass('active');
			jQuery(currentAttrValue).slideDown(300).addClass('open'); 
		} 
		e.preventDefault();
	});
});</script>";
}
add_shortcode( 'accordion', 'accordion_shortcode' );
function accordionitem_shortcode( $atts, $content) {
	$atts = shortcode_atts( array(
		'title' => '',
		'class'=>'name',
		'open'=>0
	), $atts, 'accordion-item' );
	$id="accordion-".rand(10000,99999);
	return '<div class="accordion-section"><a class="accordion-section-title '.$atts['class'].'" href="#'.$id.'"><span class="left-arrow"></span>'.$atts['title'].'</a>
	<div id="'.$id.'" class="accordion-section-content">'.do_shortcode(clean($content)).'</div></div>';
}
add_shortcode( 'accordion-item', 'accordionitem_shortcode' );
