<?php
if ( class_exists( 'woocommerce' ) ) {	
	// WOOCOMMERCE
	add_theme_support( 'woocommerce' );
		
	register_sidebar( array(
		'id' => 'sidebar-woo',
		'name' => __('Woo Sidebar'),
		'description' => 'The widget for woo-commerce sidebar',
		'before_widget' => '<div class="wgs wgs-side wgs-side-woo %2$s %1$s" id="%1$s"><div class="widget-content">',
		'after_widget' => '</div></div>',
		'before_title' => '<h3 class="wg-title"><span>',
		'after_title' => '</span></h3>',
	));
	// Hide Shop page title
	add_filter('woocommerce_show_page_title', 'shop_title_hide');
	function shop_title_hide ($title) {
		if (is_shop()) return false;
		return $title;
	}	
	// Show product page page
	add_filter( 'loop_shop_per_page', 'nio_loop_shop_per_page', 20 );
	function nio_loop_shop_per_page( $shop_page_page ) {
		return 18;
	}
	
	// Column for shop
	add_filter( 'loop_shop_columns', 'nio_loop_shop_columns', 1, 10 );
	function nio_loop_shop_columns( $number_columns ) {
		global $woocommerce, $woocommerce_loop;
		// Default Shop
		$columns = 3;
		$woocommerce_loop['grids'] = 3;
		
		// Category page
		if ( is_product_category() ) { 
			$columns = 3;
			$woocommerce_loop['grids'] = 3; 
		}
		
		// Related Products
		if ( is_product() ) {
			$columns = 4;
			$woocommerce_loop['grids'] = 3;
		}
		return $columns;
	}
	
	// Disable Default CSS
	define('WOOCOMMERCE_USE_CSS', false); // version <2.1
	add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' ); // version >2.1
	
	// Remove result count / catelog ordering
	remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
	// remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
	
	// Tabs Postion switch
	remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10);
	add_action('woocommerce_single_product_summary', 'woocommerce_output_product_data_tabs', 35);
	
	// Upsell Products 
	remove_action('woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15);
	// add_action('woocommerce_after_single_product', 'woocommerce_upsell_display', 15);
	
	// Related Products
	remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
	// add_action('woocommerce_after_single_product', 'woocommerce_output_related_products', 20);
	
	// Back/Continue to Shop 
	function nio_woocommerce_back_shop() {
		global $post, $woocommerce; $out = '';
		$cur_term = wp_get_post_terms($post->ID, 'product_cat'); 
		$continue = (get_bloginfo('language')=='fr-FR') ? 'Continuer à magasiner' : 'Continue to Shop';
		if ($cur_term) { 
			$out .= '<div class="product-back">';
			$out .= '<a class="button btn-return return-cat" href="'.get_term_link($cur_term[0]->slug,'product_cat').'">'.$continue.'</a></div>'; 
		}
		echo $out;
	}
	//add_action('woocommerce_single_product_summary', 'nio_woocommerce_back_shop', 50);
	
	// add_filter( 'woocommerce_product_single_add_to_cart_text', 'nio_woocommerce_cart' );    // 2.1 +	
	function nio_woocommerce_cart() { 
        return __( 'Buy Now', 'woocommerce' );
	}
	
	// CSS File Load
	add_action( 'wp_enqueue_scripts', 'nio_woocommerce_css' );
	function nio_woocommerce_css(){
		//global $woocommerce;
		wp_enqueue_style( 'woocommerce', get_template_directory_uri() . '/css/woocommerce.css', true, '1.6.2.4' );
		
		if ( is_product() ) {
			// Zoom
			wp_enqueue_script( 'elevatezoom', get_template_directory_uri().'/js/jquery.elevatezoom.js', true, '3.0.8', true);
			$zoominit_code .= 'jQuery(document).ready(function($) {$(".ezoom").elevateZoom({ zoomType: "inner", cursor: "crosshair", zoomWindowFadeIn: 300, zoomWindowFadeOut: 300, easing : 49, responsive: true }); });';
			wp_add_inline_script ( 'elevatezoom', $zoominit_code );
			
			//Slide
			wp_enqueue_script( 'slick', get_template_directory_uri().'/js/jquery.slick.js', true, '1.6.0', true);
			$slickinit_code .= 'jQuery(document).ready(function($) {			
			$("#wcp-thumbs").slick({dots: false, infinite: false, focusOnSelect:true, vertical: true, verticalSwiping:true, slidesToShow:5, slidesToScroll: 1, asNavFor: "#wcp-slider", responsive: [ { breakpoint: 767, settings: { slidesToShow:4 } }, { breakpoint: 479, settings: { slidesToShow:3 } }] });
			$("#wcp-slider").slick({dots: false, infinite: false, slidesToShow: 1, slidesToScroll: 1, asNavFor: "#wcp-thumbs", fade: true }); 
			$(".pro-slider .slick-slide:first-child img.szoom").elevateZoom({ zoomType: "inner", cursor: "crosshair", easing : 49, responsive: true, zoomWindowFadeIn:400, zoomWindowFadeOut: 300 });
			$("#wcp-slider").on("afterChange", function(){ $(".zoomContainer").remove();
				$(".pro-slider .slick-slide.slick-current img.szoom").elevateZoom({ zoomType: "inner", cursor: "crosshair", easing : 49, responsive: true, zoomWindowFadeIn:400, zoomWindowFadeOut: 300 });
			});
			});';
			wp_add_inline_script ( 'slick', $slickinit_code );
		}
	}
	
	// MINI CART
	add_filter( 'wp_nav_menu_items', 'woo_minicart_nav_items', 10, 2 );
	function woo_minicart_nav_items( $items, $args ) {
		if ( $args->theme_location != 'top-nav' && $args->theme_location != 'top-nav-logged' )
			return $items;
		global $woocommerce; $cartlink = ''; $minicart = false;
		$cart_text = (get_bloginfo('language')=='fr-FR') ? "Panier" : "Cart";
		$cart_count = $woocommerce->cart->cart_contents_count;
		$cartlink .= '<li id="basketlink" class="basket-link">';
		$cartlink .= '<a class="basket" href="'.wc_get_cart_url().'">'.sprintf( __('<span>'.$cart_text.'</span> <i class="count">(%d)</i>'), $cart_count ).'</a>';
		if( !is_cart() && !is_checkout() && $minicart == true ) :
			$cartlink .= '<div id="minicart">';
			$cartlink .= '<h4 class="minicart-cartcount">'.sprintf(_n('<strong>%d</strong> item', '<strong>%d</strong> items', $cart_count), $cart_count).' <a class="right" href="'.wc_get_cart_url().'">'.__('View Cart &rarr;').'</a></h4>';
			ob_start();
				$instance = array('title' => '', 'number' => 999);
				$args = array('before_widget' => '<div class="wgs-cart-count">', 'after_widget' => '</div>', 'before_title' => '<h4 class="wg-title">', 'title' => '', 'after_title' => '</h4>');
				
				if ( version_compare( WOOCOMMERCE_VERSION, '2.0', '<' ) ) {
				  $mini_cart = new WooCommerce_Widget_Cart();
				} else {
				  $mini_cart = new WC_Widget_Cart();
				}
				
				$mini_cart->number = $instance['number'];
				$mini_cart->widget($args,$instance);
			$cartlink .= ob_get_clean();
			if ( $cart_count > 0 ) 
				$cartlink .= '<a class="miniButton" href="'.wc_get_checkout_url().'">'.__('Checkout').'</a>';
			else 
				$cartlink .= '<a class="miniButton" href="'.get_permalink(get_option('woocommerce_shop_page_id')).'">'.__('Visit Shop').'</a>';
			$cartlink .= '</div>';
		endif;
		$cartlink .= '</li>';
		
		$return = $cartlink.$items;
		return $return;
	}
	
	// WooCart Count
	function woo_cart_count($minicart=false) {
		global $woocommerce; $cartlink = ''; 
		
		$cart_text = (get_bloginfo('language')=='fr-FR') ? "Panier" : "Cart";
		$cart_count = $woocommerce->cart->cart_contents_count;
		
		$cartlink .= '<div class="icart-count cart-count">';
		$cartlink .= '<a class="basket" href="'.wc_get_cart_url().'">'.sprintf( __('<i class="fa fa-shopping-cart"></i><span> '.$cart_text.'</span> <i class="count">%d</i>'), $cart_count ).'</a>';
		
		if( !is_cart() && !is_checkout() && $minicart == true ) :
			$cartlink .= '<div id="minicart">';
			$cartlink .= '<h4 class="minicart-cartcount">'.sprintf(_n('<strong>%d</strong> item', '<strong>%d</strong> items', $cart_count), $cart_count).' <a class="right" href="'.wc_get_cart_url().'">'.__('View Cart &rarr;').'</a></h4>';
			ob_start();
				$instance = array('title' => '', 'number' => 999);
				$args = array('before_widget' => '<div class="cart-views">', 'after_widget' => '</div>', 'before_title' => '<h4 class="wg-title">', 'title' => '', 'after_title' => '</h4>');
				
				if ( version_compare( WOOCOMMERCE_VERSION, '2.0', '<' ) ) {
				  $mini_cart = new WooCommerce_Widget_Cart();
				} else {
				  $mini_cart = new WC_Widget_Cart();
				}
				
				$mini_cart->number = $instance['number'];
				$mini_cart->widget($args,$instance);
			$cartlink .= ob_get_clean();
			if ( $cart_count > 0 ) 
				$cartlink .= '<a class="miniButton" href="'.wc_get_checkout_url().'">'.__('Checkout').'</a>';
			else 
				$cartlink .= '<a class="miniButton" href="'.get_permalink(get_option('woocommerce_shop_page_id')).'">'.__('Visit Shop').'</a>';
			$cartlink .= '</div>';
		endif;
		$cartlink .= '</div>';
		
		echo $cartlink;
	}
	// End
}