<?php
/**
 * @package ThemeNio @ver/1.6 @file/1.0
 * @content-loop.php - Template part of content for loop
**/
?>
<div class="summary">
    <header class="page-title post-title">
        <h2 class="heading"><a href="<?php the_permalink() ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h2>
		<?php if (!is_search()) : ?>
        <div class="post-meta">
            <span class="post-date"><?php the_time('F j, Y') ?></span>
            <?php /* <span class="post-by">By <?php the_author(); ?></span> <span class="post-tags"><?php the_tags('Tags: ', ', ', ''); ?></span> */ ?>
        </div>
        <?php endif; ?>
    </header>
	<?php if ( has_post_thumbnail() ) : ?>
    <figure class="thumbs thumbs-post">
        <a href="<?php the_permalink() ?>" title="<?php the_title(); ?>">
			<?php the_post_thumbnail('medium'); ?>
            <span class="over"><i class="icon-link fa fa-link"></i></span>
        </a>
    </figure>
    <?php endif; ?>
    <div class="entry-content entry">
        <?php if (!is_search()) : the_excerpt(); else : echo excerpt(20); endif; ?>
    </div>
    <div class="entry-more">
        <a href="<?php the_permalink() ?>" class="button btn-more">Read More</a>
    </div>
</div>
<div class="clr"></div>