<?php
/**
 * @package ThemeNio @ver/1.6 @file/1.0
 * @content-none.php - Template Part of content for not found
**/
?>
<?php if (is_404()) : ?>
<article class="article post not-found error404">
	<h1 class="heading"><strong>404</strong> Error!</h1>
	<div class="entry">
		<p>Apologies, but the page you requested could not be found or has been removed.</p>
        <p>Perhaps searching will help you or return to <a href="<?php echo esc_url( home_url( '/' ) ); ?>">homepage</a>.</p>
        <div class="gap gap-size-small"></div>
		<?php get_search_form(); ?>
	</div>
</article>
<?php elseif (is_search()) : ?>
<article class="article post not-found no-result">
	<h2 class="heading">Sorry, no results were found</h2>
	<div class="entry">
        <h4>Suggestions:</h4>
        <ul class="dot">
        	<li>Make sure all words are spelled correctly.</li>
            <li>Try different keywords.</li>
            <li>Try more general keywords.</li>
        </ul>
	</div>
</article>
<?php elseif (is_archive()) : ?>
<article class="article post not-found no-post center">
	<?php 
    if ( is_category() ) { // If this is a category archive
        printf("<h2 class='heading'>Sorry, but there aren't any posts in the %s category yet.</h2>", single_cat_title('',false));
    } else if ( is_date() ) { // If this is a date archive
        echo("<h2 class='heading'>Sorry, but there aren't any posts with this date.</h2>");
    } else if ( is_author() ) { // If this is a category archive
        $userdata = get_user_by(get_query_var('author_name'));
        printf("<h2 class='heading'>Sorry, but there aren't any posts by %s yet.</h2>", $userdata->display_name);
    } else {
        echo("<h2 class='heading'>No posts found.</h2>");
    } ?>
    <div class="entry">
        <p>Perhaps searching will help you or return to <a href="<?php echo esc_url( home_url( '/' ) ); ?>">homepage</a>.</p>
        <div class="gap gap-size-small"></div>
        <?php get_search_form(); ?>
    </div>
</article>
<?php else : ?>
<article class="article post not-found no-entry center">
	<h2 class="heading">Nothing found</h2>
	<div class="entry">
		<p><a class="button btn-small" href="<?php echo esc_url( home_url( '/' ) ); ?>">Return to Home</a></p>
	</div>
</article>
<?php endif; ?>
