<?php
/**
 * @package ThemeNio @ver/1.6 @file/1.0
 * @content.php - Template Part of content for default
**/
?>
<article <?php post_class('ep dloop'); ?>>
	<header class="page-heading post-title">
		<h2 class="heading"><a href="<?php the_permalink() ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h2>
		<?php if ( 'post' == get_post_type() ) : ?>
        <div class="post-date"><span class="pub-date"><?php the_time('F j, Y') ?></span></div>
		<?php endif; ?>
	</header>
    <?php if ( has_post_thumbnail() ) : ?>
    <figure class="thumbs thumbs-post">
		<?php the_post_thumbnail('full-size'); ?>
    </figure>
    <?php endif; ?>
	<div class="entry-content entry">
		<?php the_excerpt(); ?>
	</div>
    <div class="entry-more">
    	<a href="<?php the_permalink(); ?>" class="button btn-more">Read more</a>
    </div>
</article>